/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.event.client;

import com.facebook.airlift.event.client.DummyEventClass;
import com.facebook.airlift.event.client.EventType;
import com.facebook.airlift.event.client.EventTypeMetadata;
import com.facebook.airlift.testing.Assertions;
import com.google.common.base.Joiner;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestEventValidation {
    @Test
    public void testLegacyEventTypeName() {
        EventTypeMetadata.getValidEventTypeMetadata(DummyEventClass.class);
    }

    @Test
    public void testInvalidEventTypeName() {
        @EventType(value="junk!")
        class TestEvent {
            TestEvent() {
            }
        }
        TestEventValidation.assertInvalidEvent(TestEvent.class, "Event name is invalid");
    }

    @Test
    public void testMissingEventTypeAnnotation() {
        class TestEvent {
            TestEvent() {
            }
        }
        TestEventValidation.assertInvalidEvent(TestEvent.class, "is not annotated with");
    }

    @Test
    public void testMissingEventTypeName() {
        @EventType
        class TestEvent {
            TestEvent() {
            }
        }
        TestEventValidation.assertInvalidEvent(TestEvent.class, "does not specify an event name");
    }

    @Test
    public void testEventTypeNameForNestedEvent() {
        Assert.assertEquals((String)EventTypeMetadata.getEventTypeMetadataNested(4TestEvent.Nested.class).getTypeName(), (String)"NestedCustom");
        Assert.assertEquals((String)EventTypeMetadata.getEventTypeMetadataNested(4TestEvent.Nested2.class).getTypeName(), (String)4TestEvent.Nested2.class.getSimpleName());
    }

    private static void assertInvalidEvent(Class<?> eventClass, String errorPart) {
        EventTypeMetadata metadata = EventTypeMetadata.getEventTypeMetadata(eventClass);
        List errors = metadata.getErrors();
        Assert.assertEquals((int)errors.size(), (int)1, (String)("expected exactly one error:\n" + Joiner.on((char)'\n').join((Iterable)errors)));
        Assertions.assertContains((String)((String)errors.get(0)), (String)errorPart);
    }
}

