/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.event.client;

import com.facebook.airlift.event.client.ChainedCircularEventClass;
import com.facebook.airlift.event.client.CircularEventClass;
import com.facebook.airlift.event.client.EventClient;
import com.facebook.airlift.event.client.EventTypeMetadata;
import com.facebook.airlift.event.client.FixedDummyEventClass;
import com.facebook.airlift.event.client.FixedDummyEventWithZonedDateTimeClass;
import com.facebook.airlift.event.client.InvalidEventException;
import com.facebook.airlift.event.client.JsonEventWriter;
import com.facebook.airlift.event.client.NestedDummyEventClass;
import com.facebook.airlift.event.client.NestedDummyEventWithZonedDateTimeClass;
import com.facebook.airlift.event.client.TestingUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJsonEventWriter {
    private JsonEventWriter eventWriter;

    @BeforeClass
    public void setup() throws Exception {
        Set eventTypes = EventTypeMetadata.getValidEventTypeMetaDataSet((Class[])new Class[]{FixedDummyEventClass.class, FixedDummyEventWithZonedDateTimeClass.class, NestedDummyEventClass.class, NestedDummyEventWithZonedDateTimeClass.class, CircularEventClass.class, ChainedCircularEventClass.class});
        this.eventWriter = new JsonEventWriter(eventTypes);
    }

    @Test
    public void testEventWriter() throws Exception {
        this.assertEventJson(TestJsonEventWriter.createEventGenerator(TestingUtils.getEvents()), "events.json");
    }

    @Test
    public void testNullValue() throws Exception {
        FixedDummyEventClass event = new FixedDummyEventClass("localhost", new DateTime((Object)"2011-09-09T01:59:59.999Z"), UUID.fromString("1ea8ca34-db36-11e0-b76f-8b7d505ab1ad"), 123, null);
        this.assertEventJson(TestJsonEventWriter.createEventGenerator(ImmutableList.of((Object)event)), "nullValue.json");
    }

    @Test
    public void testNullValueWithZonedDateTime() throws Exception {
        FixedDummyEventWithZonedDateTimeClass event = new FixedDummyEventWithZonedDateTimeClass("localhost", ZonedDateTime.parse("2011-09-09T01:59:59.999Z"), UUID.fromString("1ea8ca34-db36-11e0-b76f-8b7d505ab1ad"), 123, null);
        this.assertEventJson(TestJsonEventWriter.createEventGenerator(ImmutableList.of((Object)event)), "nullValue.json");
    }

    @Test
    public void testNestedEvent() throws Exception {
        NestedDummyEventClass nestedEvent = new NestedDummyEventClass("localhost", new DateTime((Object)"2011-09-09T01:48:08.888Z"), UUID.fromString("6b598c2a-0a95-4f3f-9298-5a4d70ca13fc"), 9999, "nested", (List<String>)ImmutableList.of((Object)"abc", (Object)"xyz"), new NestedDummyEventClass.NestedPart("first", new NestedDummyEventClass.NestedPart("second", new NestedDummyEventClass.NestedPart("third", null))), (List<NestedDummyEventClass.NestedPart>)ImmutableList.of((Object)new NestedDummyEventClass.NestedPart("listFirst", new NestedDummyEventClass.NestedPart("listSecond", null)), (Object)new NestedDummyEventClass.NestedPart("listThird", null)));
        this.assertEventJson(TestJsonEventWriter.createEventGenerator(ImmutableList.of((Object)nestedEvent)), "nested.json");
    }

    @Test
    public void testNestedEventWithZonedDateTime() throws Exception {
        NestedDummyEventWithZonedDateTimeClass nestedEvent = new NestedDummyEventWithZonedDateTimeClass("localhost", ZonedDateTime.parse("2011-09-09T01:48:08.888Z"), UUID.fromString("6b598c2a-0a95-4f3f-9298-5a4d70ca13fc"), 9999, "nested", (List<String>)ImmutableList.of((Object)"abc", (Object)"xyz"), new NestedDummyEventWithZonedDateTimeClass.NestedPart("first", new NestedDummyEventWithZonedDateTimeClass.NestedPart("second", new NestedDummyEventWithZonedDateTimeClass.NestedPart("third", null))), (List<NestedDummyEventWithZonedDateTimeClass.NestedPart>)ImmutableList.of((Object)new NestedDummyEventWithZonedDateTimeClass.NestedPart("listFirst", new NestedDummyEventWithZonedDateTimeClass.NestedPart("listSecond", null)), (Object)new NestedDummyEventWithZonedDateTimeClass.NestedPart("listThird", null)));
        this.assertEventJson(TestJsonEventWriter.createEventGenerator(ImmutableList.of((Object)nestedEvent)), "nested.json");
    }

    @Test(expectedExceptions={InvalidEventException.class}, expectedExceptionsMessageRegExp="Cycle detected in event data:.*")
    public void testCircularEvent() throws Exception {
        this.eventWriter.writeEvents(TestJsonEventWriter.createEventGenerator(ImmutableList.of((Object)new CircularEventClass())), ByteStreams.nullOutputStream());
    }

    @Test(expectedExceptions={InvalidEventException.class}, expectedExceptionsMessageRegExp="Cycle detected in event data:.*")
    public void testChainedCircularEvent() throws Exception {
        ChainedCircularEventClass.ChainedPart a = new ChainedCircularEventClass.ChainedPart("a");
        ChainedCircularEventClass.ChainedPart b = new ChainedCircularEventClass.ChainedPart("b");
        ChainedCircularEventClass.ChainedPart c = new ChainedCircularEventClass.ChainedPart("c");
        a.setPart(b);
        b.setPart(c);
        c.setPart(a);
        ChainedCircularEventClass event = new ChainedCircularEventClass(a);
        this.eventWriter.writeEvents(TestJsonEventWriter.createEventGenerator(ImmutableList.of((Object)event)), ByteStreams.nullOutputStream());
    }

    private void assertEventJson(EventClient.EventGenerator<?> events, String resource) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.eventWriter.writeEvents(events, (OutputStream)out);
        String json = out.toString(StandardCharsets.UTF_8.name());
        Assert.assertEquals((String)json, (String)TestingUtils.getNormalizedJson(resource));
    }

    private static <T> EventClient.EventGenerator<T> createEventGenerator(Iterable<T> events) {
        return eventPoster -> {
            for (Object event : events) {
                eventPoster.post(event);
            }
        };
    }
}

