/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.event.client;

import com.facebook.airlift.event.client.TypeParameterUtils;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypeParametersUtils {
    public Map mapNotGeneric;
    public Map<Key, Value> mapSimple;
    public Map<?, ?> mapWildcard;
    public Map<? extends Key, ? extends Value> mapExtendsWildcard;
    public Map<? super Key, ? extends Value> mapSuperWildcard;
    public MyMap myMapNotGeneric;
    public MyMap<Fake, Value, Key> myMapSimple;
    public MyMap<?, ?, ?> myMapWildcard;
    public MyMap<? extends Fake, ? extends Value, ? extends Key> myMapExtendsWildcard;
    public MyMap<? super Fake, ? super Value, ? extends Key> myMapSuperWildcard;
    public FixedMap fixedMap;

    @Test
    public void testMap() throws Exception {
        Assert.assertNull((Object)this.getParameters("mapNotGeneric"));
        Assert.assertEquals((Object[])this.getParameters("mapSimple"), (Object[])new Type[]{Key.class, Value.class});
        TestTypeParametersUtils.assertTwoWildcardTypes(this.getParameters("mapWildcard"));
        TestTypeParametersUtils.assertTwoWildcardTypes(this.getParameters("mapExtendsWildcard"));
        TestTypeParametersUtils.assertTwoWildcardTypes(this.getParameters("mapSuperWildcard"));
    }

    @Test
    public void testMyMap() throws Exception {
        TestTypeParametersUtils.assertTwoTypeVariables(this.getParameters("myMapNotGeneric"));
        Assert.assertEquals((Object[])this.getParameters("myMapSimple"), (Object[])new Type[]{Key.class, Value.class});
        TestTypeParametersUtils.assertTwoWildcardTypes(this.getParameters("myMapWildcard"));
        TestTypeParametersUtils.assertTwoWildcardTypes(this.getParameters("myMapExtendsWildcard"));
        TestTypeParametersUtils.assertTwoWildcardTypes(this.getParameters("myMapSuperWildcard"));
    }

    @Test
    public void testFixedMap() throws Exception {
        Assert.assertEquals((Object[])this.getParameters("fixedMap"), (Object[])new Type[]{Key.class, Value.class});
    }

    private static void assertTwoWildcardTypes(Type[] types) {
        Assert.assertEquals((int)types.length, (int)2);
        for (Type type : types) {
            TestTypeParametersUtils.assertInstanceOf(type, WildcardType.class);
        }
    }

    private static void assertTwoTypeVariables(Type[] types) {
        Assert.assertEquals((int)types.length, (int)2);
        for (Type type : types) {
            TestTypeParametersUtils.assertInstanceOf(type, TypeVariable.class);
        }
    }

    private static void assertInstanceOf(Type type, Class<?> clazz) {
        Assert.assertTrue((boolean)clazz.isInstance(type), (String)String.format("[%s] is not instance of %s", type, clazz.getSimpleName()));
    }

    private Type[] getParameters(String fieldName) throws Exception {
        return TypeParameterUtils.getTypeParameters(Map.class, (Type)this.getClass().getField(fieldName).getGenericType());
    }

    public static class Value {
    }

    public static class Key {
    }

    public static class Fake {
    }

    public static class FixedMap
    extends MyMap<Fake, Value, Key> {
    }

    public static class MyMap<X, V, K>
    extends AbstractMap<K, V> {
        public Iterator<K> iterator() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

