/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.http.client.DefaultingJsonResponseHandler;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.testing.TestingResponse;
import com.facebook.airlift.json.JsonCodec;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.net.MediaType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultingJsonResponseHandler {
    private static final User DEFAULT_VALUE = new User("defaultUser", 998);
    private final JsonCodec<User> codec = JsonCodec.jsonCodec(User.class);
    private final DefaultingJsonResponseHandler<User> handler = DefaultingJsonResponseHandler.createDefaultingJsonResponseHandler(this.codec, (Object)DEFAULT_VALUE);

    @Test
    public void testValidJson() throws Exception {
        User user = new User("Joe", 25);
        String json = this.codec.toJson((Object)user);
        User response = (User)this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)json));
        Assert.assertEquals((String)response.getName(), (String)user.getName());
        Assert.assertEquals((int)response.getAge(), (int)user.getAge());
    }

    @Test
    public void testInvalidJson() {
        String json = "{\"age\": \"foo\"}";
        User response = (User)this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)json));
        Assert.assertSame((Object)response, (Object)DEFAULT_VALUE);
    }

    @Test
    public void testException() {
        User response = (User)this.handler.handleException(null, null);
        Assert.assertSame((Object)response, (Object)DEFAULT_VALUE);
    }

    @Test
    public void testNonJsonResponse() {
        User response = (User)this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"hello"));
        Assert.assertSame((Object)response, (Object)DEFAULT_VALUE);
    }

    @Test
    public void testJsonErrorResponse() {
        String json = "{\"error\": true}";
        User response = (User)this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (MediaType)MediaType.JSON_UTF_8, (String)json));
        Assert.assertSame((Object)response, (Object)DEFAULT_VALUE);
    }

    public static class User {
        private final String name;
        private final int age;

        @JsonCreator
        public User(@JsonProperty(value="name") String name, @JsonProperty(value="age") int age) {
            this.name = name;
            this.age = age;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public int getAge() {
            return this.age;
        }
    }
}

