/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.airlift.http.client.HttpClientConfig;
import com.facebook.airlift.http.client.KerberosNameType;
import com.facebook.airlift.testing.ValidationAssertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.testng.annotations.Test;

public class TestHttpClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HttpClientConfig)ConfigAssertions.recordDefaults(HttpClientConfig.class)).setHttp2Enabled(false).setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS)).setRequestTimeout(new Duration(5.0, TimeUnit.MINUTES)).setIdleTimeout(new Duration(1.0, TimeUnit.MINUTES)).setKeepAliveInterval(null).setMaxConnections(200).setMaxConnectionsPerServer(20).setMaxRequestsQueuedPerDestination(1024).setMaxContentLength(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setRequestBufferSize(new DataSize(4.0, DataSize.Unit.KILOBYTE)).setResponseBufferSize(new DataSize(16.0, DataSize.Unit.KILOBYTE)).setSocksProxy(null).setKeyStorePath(System.getProperty("javax.net.ssl.keyStore")).setKeyStorePassword(System.getProperty("javax.net.ssl.keyStorePassword")).setTrustStorePath(System.getProperty("javax.net.ssl.trustStore")).setTrustStorePassword(System.getProperty("javax.net.ssl.trustStorePassword")).setSecureRandomAlgorithm(null).setHttpsIncludedCipherSuites("").setHttpsExcludedCipherSuites(String.join((CharSequence)",", this.getJettyDefaultExcludedCiphers())).setAuthenticationEnabled(false).setKerberosServicePrincipalPattern("${SERVICE}@${HOST}").setKerberosRemoteServiceName(null).setKerberosPrincipal(null).setKerberosNameType(KerberosNameType.HOSTBASED_SERVICE).setHttp2InitialSessionReceiveWindowSize(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setHttp2InitialStreamReceiveWindowSize(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setHttp2InputBufferSize(new DataSize(8.0, DataSize.Unit.KILOBYTE)).setSelectorCount(2).setRecordRequestComplete(true).setConnectBlocking(false).setMaxThreads(200).setMinThreads(8).setTimeoutConcurrency(1).setTimeoutThreads(1).setLogEnabled(false).setLogHistory(15).setLogMaxFileSize(new DataSize(1.0, DataSize.Unit.GIGABYTE)).setLogPath("var/log/").setLogQueueSize(10000).setLogBufferSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).setLogFlushInterval(new Duration(10.0, TimeUnit.SECONDS)).setLogCompressionEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"http-client.http2.enabled", (Object)"true").put((Object)"http-client.connect-timeout", (Object)"4s").put((Object)"http-client.request-timeout", (Object)"15s").put((Object)"http-client.idle-timeout", (Object)"5s").put((Object)"http-client.keep-alive-interval", (Object)"6s").put((Object)"http-client.max-connections", (Object)"12").put((Object)"http-client.max-connections-per-server", (Object)"3").put((Object)"http-client.max-requests-queued-per-destination", (Object)"10").put((Object)"http-client.max-content-length", (Object)"1MB").put((Object)"http-client.request-buffer-size", (Object)"42kB").put((Object)"http-client.response-buffer-size", (Object)"43kB").put((Object)"http-client.socks-proxy", (Object)"localhost:1080").put((Object)"http-client.secure-random-algorithm", (Object)"NativePRNG").put((Object)"http-client.https.included-cipher", (Object)"TLS_RSA_WITH_AES_128_CBC_SHA,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA").put((Object)"http-client.https.excluded-cipher", (Object)"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA").put((Object)"http-client.key-store-path", (Object)"key-store").put((Object)"http-client.key-store-password", (Object)"key-store-password").put((Object)"http-client.trust-store-path", (Object)"trust-store").put((Object)"http-client.trust-store-password", (Object)"trust-store-password").put((Object)"http-client.authentication.enabled", (Object)"true").put((Object)"http-client.authentication.krb5.service-principal-pattern", (Object)"${SERVICE}").put((Object)"http-client.authentication.krb5.remote-service-name", (Object)"airlift").put((Object)"http-client.authentication.krb5.principal", (Object)"airlift-client").put((Object)"http-client.authentication.krb5.name-type", (Object)"USER_NAME").put((Object)"http-client.http2.session-receive-window-size", (Object)"7MB").put((Object)"http-client.http2.stream-receive-window-size", (Object)"7MB").put((Object)"http-client.http2.input-buffer-size", (Object)"1MB").put((Object)"http-client.selector-count", (Object)"16").put((Object)"http-client.record-request-complete", (Object)"false").put((Object)"http-client.use-blocking-connect", (Object)"true").put((Object)"http-client.max-threads", (Object)"33").put((Object)"http-client.min-threads", (Object)"11").put((Object)"http-client.timeout-concurrency", (Object)"33").put((Object)"http-client.timeout-threads", (Object)"44").put((Object)"http-client.log.enabled", (Object)"true").put((Object)"http-client.log.max-history", (Object)"22").put((Object)"http-client.log.max-size", (Object)"2GB").put((Object)"http-client.log.path", (Object)"/tmp/log/").put((Object)"http-client.log.queue-size", (Object)"12345").put((Object)"http-client.log.buffer-size", (Object)"3MB").put((Object)"http-client.log.flush-interval", (Object)"99s").put((Object)"http-client.log.compression.enabled", (Object)"false").build();
        HttpClientConfig expected = new HttpClientConfig().setHttp2Enabled(true).setConnectTimeout(new Duration(4.0, TimeUnit.SECONDS)).setRequestTimeout(new Duration(15.0, TimeUnit.SECONDS)).setIdleTimeout(new Duration(5.0, TimeUnit.SECONDS)).setKeepAliveInterval(new Duration(6.0, TimeUnit.SECONDS)).setMaxConnections(12).setMaxConnectionsPerServer(3).setMaxRequestsQueuedPerDestination(10).setMaxContentLength(new DataSize(1.0, DataSize.Unit.MEGABYTE)).setRequestBufferSize(new DataSize(42.0, DataSize.Unit.KILOBYTE)).setResponseBufferSize(new DataSize(43.0, DataSize.Unit.KILOBYTE)).setSocksProxy(HostAndPort.fromParts((String)"localhost", (int)1080)).setKeyStorePath("key-store").setKeyStorePassword("key-store-password").setTrustStorePath("trust-store").setTrustStorePassword("trust-store-password").setSecureRandomAlgorithm("NativePRNG").setHttpsIncludedCipherSuites("TLS_RSA_WITH_AES_128_CBC_SHA,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA").setHttpsExcludedCipherSuites("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA").setAuthenticationEnabled(true).setKerberosServicePrincipalPattern("${SERVICE}").setKerberosRemoteServiceName("airlift").setKerberosPrincipal("airlift-client").setKerberosNameType(KerberosNameType.USER_NAME).setHttp2InitialSessionReceiveWindowSize(new DataSize(7.0, DataSize.Unit.MEGABYTE)).setHttp2InitialStreamReceiveWindowSize(new DataSize(7.0, DataSize.Unit.MEGABYTE)).setHttp2InputBufferSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).setSelectorCount(16).setRecordRequestComplete(false).setConnectBlocking(true).setMaxThreads(33).setMinThreads(11).setTimeoutConcurrency(33).setTimeoutThreads(44).setLogEnabled(true).setLogHistory(22).setLogMaxFileSize(new DataSize(2.0, DataSize.Unit.GIGABYTE)).setLogPath("/tmp/log/").setLogQueueSize(12345).setLogBufferSize(new DataSize(3.0, DataSize.Unit.MEGABYTE)).setLogFlushInterval(new Duration(99.0, TimeUnit.SECONDS)).setLogCompressionEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testDeprecatedProperties() {
        ImmutableMap currentProperties = new ImmutableMap.Builder().put((Object)"http-client.idle-timeout", (Object)"111m").build();
        ImmutableMap oldProperties = new ImmutableMap.Builder().put((Object)"http-client.read-timeout", (Object)"111m").build();
        ConfigAssertions.assertDeprecatedEquivalence(HttpClientConfig.class, (Map)currentProperties, (Map[])new Map[]{oldProperties});
    }

    @Test
    public void testValidations() {
        ValidationAssertions.assertFailsValidation((Object)new HttpClientConfig().setConnectTimeout(null), (String)"connectTimeout", (String)"may not be null", NotNull.class);
        ValidationAssertions.assertFailsValidation((Object)new HttpClientConfig().setRequestTimeout(null), (String)"requestTimeout", (String)"may not be null", NotNull.class);
        ValidationAssertions.assertFailsValidation((Object)new HttpClientConfig().setIdleTimeout(null), (String)"idleTimeout", (String)"may not be null", NotNull.class);
    }

    private List<String> getJettyDefaultExcludedCiphers() {
        SslContextFactory sslContextFactory = new SslContextFactory();
        return Arrays.asList(sslContextFactory.getExcludeCipherSuites());
    }
}

