/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.facebook.airlift.testing.EquivalenceTester;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.net.URI;
import org.testng.annotations.Test;

public class TestRequest {
    @Test
    public void testEquivalence() {
        BodyGenerator bodyGenerator = TestRequest.createBodyGenerator();
        EquivalenceTester.equivalenceTester().addEquivalentGroup((Object)Request.Builder.prepareGet().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).build(), new Object[]{Request.Builder.prepareGet().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).build(), Request.Builder.prepareGet().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).setFollowRedirects(true).build(), Request.Builder.prepareGet().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).setPreserveAuthorizationOnRedirect(false).build()}).addEquivalentGroup((Object)Request.Builder.preparePut().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).setFollowRedirects(false).build(), new Object[0]).addEquivalentGroup((Object)Request.Builder.preparePut().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).setPreserveAuthorizationOnRedirect(true).build(), new Object[0]).addEquivalentGroup((Object)Request.Builder.prepareGet().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).setBodyGenerator(bodyGenerator).build(), new Object[]{Request.Builder.prepareGet().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).setBodyGenerator(bodyGenerator).build()}).addEquivalentGroup((Object)Request.Builder.prepareGet().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersB()).setBodyGenerator(bodyGenerator).build(), new Object[0]).addEquivalentGroup((Object)Request.Builder.prepareGet().setUri(TestRequest.createUriB()).addHeaders(TestRequest.createHeadersA()).setBodyGenerator(bodyGenerator).build(), new Object[0]).addEquivalentGroup((Object)Request.Builder.preparePut().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).build(), new Object[]{Request.Builder.preparePut().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).build()}).addEquivalentGroup((Object)Request.Builder.preparePut().setUri(TestRequest.createUriB()).addHeaders(TestRequest.createHeadersA()).build(), new Object[0]).addEquivalentGroup((Object)Request.Builder.preparePut().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersB()).build(), new Object[0]).addEquivalentGroup((Object)Request.Builder.preparePut().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).setBodyGenerator(bodyGenerator).build(), new Object[]{Request.Builder.preparePut().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).setBodyGenerator(bodyGenerator).build()}).addEquivalentGroup((Object)Request.Builder.prepareGet().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).setBodyGenerator(TestRequest.createBodyGenerator()).build(), new Object[0]).addEquivalentGroup((Object)Request.Builder.preparePut().setUri(TestRequest.createUriA()).addHeaders(TestRequest.createHeadersA()).setBodyGenerator(TestRequest.createBodyGenerator()).build(), new Object[0]).check();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Cannot make requests to HTTP port 0")
    public void testCannotMakeRequestToIllegalPort() {
        Request.Builder.prepareGet().setUri(URI.create("http://example.com:0/")).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="uri does not have a host: http:///foo")
    public void testInvalidUriMissingHost() {
        Request.Builder.prepareGet().setUri(URI.create("http:///foo")).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="uri does not have a scheme: //foo")
    public void testInvalidUriMissingScheme() {
        Request.Builder.prepareGet().setUri(URI.create("//foo")).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="uri scheme must be http or https: gopher://example.com")
    public void testInvalidUriScheme() {
        Request.Builder.prepareGet().setUri(URI.create("gopher://example.com")).build();
    }

    private static URI createUriA() {
        return URI.create("http://example.com");
    }

    private static URI createUriB() {
        return URI.create("http://example.net");
    }

    private static ListMultimap<String, String> createHeadersA() {
        return ImmutableListMultimap.builder().put((Object)"foo", (Object)"bar").put((Object)"abc", (Object)"xyz").build();
    }

    private static ListMultimap<String, String> createHeadersB() {
        return ImmutableListMultimap.builder().put((Object)"foo", (Object)"bar").put((Object)"abc", (Object)"xyz").put((Object)"qqq", (Object)"www").put((Object)"foo", (Object)"zzz").build();
    }

    public static BodyGenerator createBodyGenerator() {
        return StaticBodyGenerator.createStaticBodyGenerator((byte[])new byte[0]);
    }
}

