/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.concurrent.Threads;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class TestingSocksProxy
implements Closeable {
    private static final int SOCKS_4_SUCCESS = 90;
    private static final int SOCKS_4_FAILED = 91;
    private static final int SOCKS_5_ADDRESS_V4 = 1;
    private static final int SOCKS_5_ADDRESS_DOMAIN = 3;
    private static final int SOCKS_5_ADDRESS_V6 = 4;
    private static final int SOCKS_5_STATUS_SUCCESS = 0;
    private static final int SOCKS_5_STATUS_FAILED = 1;
    private final int bindPort;
    private HostAndPort hostAndPort;
    private ListeningExecutorService executorService;
    private ServerSocket serverSocket;

    public TestingSocksProxy() {
        this(0);
    }

    public TestingSocksProxy(int bindPort) {
        this.bindPort = bindPort;
    }

    public synchronized HostAndPort getHostAndPort() {
        Preconditions.checkState((this.hostAndPort != null ? 1 : 0) != 0, (String)"%s is not running", (Object)this.getClass().getName());
        return this.hostAndPort;
    }

    public synchronized TestingSocksProxy start() throws IOException {
        Preconditions.checkState((this.serverSocket == null ? 1 : 0) != 0, (String)"%s already started", (Object)this.getClass().getName());
        try {
            this.serverSocket = new ServerSocket(this.bindPort, 50, InetAddress.getByName("127.0.0.1"));
            this.hostAndPort = HostAndPort.fromParts((String)this.serverSocket.getInetAddress().getHostAddress(), (int)this.serverSocket.getLocalPort());
            this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.threadsNamed((String)("socks-proxy-" + this.serverSocket.getLocalPort() + "-%s"))));
            this.executorService.execute((Runnable)new SocksProxyAcceptor(this.serverSocket, this.executorService));
            return this;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public synchronized void close() {
        this.hostAndPort = null;
        if (this.serverSocket != null) {
            TestingSocksProxy.closeIgnoreException(this.serverSocket);
            this.serverSocket = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    private static void closeIgnoreException(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class Pipe
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        private Pipe(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                ByteStreams.copy((InputStream)this.in, (OutputStream)this.out);
            }
            catch (IOException iOException) {
            }
            finally {
                TestingSocksProxy.closeIgnoreException(this.in);
                TestingSocksProxy.closeIgnoreException(this.out);
            }
        }
    }

    private static class SocksProxyWorker
    implements Runnable {
        private final Socket socket;
        private final ListeningExecutorService executor;

        private SocksProxyWorker(Socket socket, ListeningExecutorService executor) {
            this.socket = socket;
            this.executor = executor;
        }

        @Override
        public void run() {
            try {
                this.connect();
            }
            catch (IOException e) {
            }
            finally {
                TestingSocksProxy.closeIgnoreException(this.socket);
            }
        }

        private void connect() throws IOException {
            DataInputStream sourceInput = new DataInputStream(this.socket.getInputStream());
            DataOutputStream sourceOutput = new DataOutputStream(this.socket.getOutputStream());
            int version = sourceInput.read();
            if (version == 4) {
                this.socks4(sourceInput, sourceOutput);
            } else if (version == 5) {
                this.socks5(sourceInput, sourceOutput);
            }
        }

        private void socks4(DataInputStream sourceInput, DataOutputStream sourceOutput) throws IOException {
            Socket targetSocket;
            int command = sourceInput.read();
            int port = sourceInput.readUnsignedShort();
            int address = sourceInput.readInt();
            while (sourceInput.read() != 0) {
            }
            if (command != 1) {
                SocksProxyWorker.responseSocks4(sourceOutput, 91, 0, 0);
                return;
            }
            String domainName = null;
            if (address != 0 && (address & 0xFFFFFF00) == 0) {
                StringBuilder domainNameBuilder = new StringBuilder(64);
                int value = sourceInput.read();
                while (value != 0) {
                    domainNameBuilder.append((char)value);
                    value = sourceInput.read();
                }
                domainName = domainNameBuilder.toString();
            }
            try {
                targetSocket = domainName != null ? new Socket(domainName, port) : new Socket(InetAddresses.fromInteger((int)address), port);
            }
            catch (IOException e) {
                SocksProxyWorker.responseSocks4(sourceOutput, 91, 0, 0);
                return;
            }
            InputStream targetInput = targetSocket.getInputStream();
            OutputStream targetOutput = targetSocket.getOutputStream();
            SocksProxyWorker.responseSocks4(sourceOutput, 90, port, InetAddresses.coerceToInteger((InetAddress)targetSocket.getInetAddress()));
            this.proxyData(sourceInput, sourceOutput, targetInput, targetOutput);
        }

        private static void responseSocks4(DataOutputStream output, int status, int port, int address) throws IOException {
            ByteArrayDataOutput sourceOutput = ByteStreams.newDataOutput();
            sourceOutput.write(0);
            sourceOutput.write(status);
            sourceOutput.writeShort(port);
            sourceOutput.writeInt(address);
            output.write(sourceOutput.toByteArray());
        }

        private void socks5(DataInputStream sourceInput, DataOutputStream sourceOutput) throws IOException {
            Socket targetSocket;
            byte[] address;
            int authMethods = sourceInput.read();
            boolean supportsNoAuth = false;
            for (int i = 0; i < authMethods; ++i) {
                if (sourceInput.read() != 0) continue;
                supportsNoAuth = true;
            }
            if (!supportsNoAuth) {
                sourceOutput.write(5);
                sourceOutput.write(255);
                return;
            }
            sourceOutput.write(5);
            sourceOutput.write(0);
            int version = sourceInput.read();
            if (version != 5) {
                return;
            }
            int command = sourceInput.read();
            sourceInput.read();
            int addressType = sourceInput.read();
            switch (addressType) {
                case 1: {
                    address = new byte[4];
                    sourceInput.readFully(address);
                    break;
                }
                case 3: {
                    address = new byte[sourceInput.read()];
                    sourceInput.readFully(address);
                    break;
                }
                case 4: {
                    address = new byte[16];
                    sourceInput.readFully(address);
                    break;
                }
                default: {
                    return;
                }
            }
            int port = sourceInput.readUnsignedShort();
            if (command != 1) {
                SocksProxyWorker.responseSocks5(sourceOutput, 1, port, addressType, address);
                return;
            }
            try {
                switch (addressType) {
                    case 1: 
                    case 4: {
                        targetSocket = new Socket(InetAddress.getByAddress(address), port);
                        break;
                    }
                    case 3: {
                        targetSocket = new Socket(new String(address, StandardCharsets.US_ASCII), port);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (IOException e) {
                SocksProxyWorker.responseSocks5(sourceOutput, 1, port, addressType, address);
                return;
            }
            InputStream targetInput = targetSocket.getInputStream();
            OutputStream targetOutput = targetSocket.getOutputStream();
            SocksProxyWorker.responseSocks5(sourceOutput, 0, port, addressType, address);
            this.proxyData(sourceInput, sourceOutput, targetInput, targetOutput);
        }

        private static void responseSocks5(DataOutputStream output, int status, int port, int addressType, byte[] address) throws IOException {
            ByteArrayDataOutput sourceOutput = ByteStreams.newDataOutput();
            sourceOutput.write(5);
            sourceOutput.write(status);
            sourceOutput.write(0);
            sourceOutput.write(addressType);
            sourceOutput.write(address);
            sourceOutput.writeShort(port);
            output.write(sourceOutput.toByteArray());
        }

        private void proxyData(InputStream sourceInput, OutputStream sourceOutput, InputStream targetInput, OutputStream targetOutput) {
            ImmutableList jobs = ImmutableList.of((Object)this.executor.submit((Runnable)new Pipe(sourceInput, targetOutput)), (Object)this.executor.submit((Runnable)new Pipe(targetInput, sourceOutput)));
            Futures.allAsList((Iterable)jobs).addListener(() -> TestingSocksProxy.closeIgnoreException(this.socket), MoreExecutors.directExecutor());
        }
    }

    private static class SocksProxyAcceptor
    implements Runnable {
        private final ServerSocket serverSocket;
        private final ListeningExecutorService executorService;
        private final AtomicBoolean closed = new AtomicBoolean();

        private SocksProxyAcceptor(ServerSocket serverSocket, ListeningExecutorService executorService) {
            this.serverSocket = serverSocket;
            this.executorService = executorService;
        }

        @Override
        public void run() {
            while (!(this.closed.get() || this.serverSocket.isClosed() || Thread.currentThread().isInterrupted())) {
                try {
                    Socket socket = this.serverSocket.accept();
                    this.executorService.execute((Runnable)new SocksProxyWorker(socket, this.executorService));
                }
                catch (IOException iOException) {}
            }
            TestingSocksProxy.closeIgnoreException(this.serverSocket);
        }
    }
}

