/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.jetty;

import com.facebook.airlift.http.client.HttpClientConfig;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.StringResponseHandler;
import com.facebook.airlift.http.client.jetty.TestJettyHttpsClient;
import com.facebook.airlift.http.client.spnego.KerberosConfig;
import java.io.File;
import java.io.UncheckedIOException;
import org.eclipse.jetty.http.HttpHeader;
import org.testng.annotations.Test;

public class TestJettyHttpsClientSpnego
extends TestJettyHttpsClient {
    @Override
    protected HttpClientConfig createClientConfig() {
        return super.createClientConfig().setAuthenticationEnabled(true).setKerberosPrincipal("invalid-for-testing").setKerberosRemoteServiceName("test");
    }

    @Override
    protected KerberosConfig createKerberosConfig() {
        return super.createKerberosConfig().setConfig(new File("/etc/krb5.conf"));
    }

    @Override
    @Test(invocationCount=10, successPercentage=50, timeOut=20000L)
    public void testConnectTimeout() throws Exception {
        super.testConnectTimeout();
    }

    @Test(expectedExceptions={UncheckedIOException.class}, expectedExceptionsMessageRegExp=".* Failed to establish LoginContext for request .*")
    public void testNegotiateAuthScheme() throws Exception {
        this.servlet.addResponseHeader("WWW-Authenticate", HttpHeader.NEGOTIATE.asString());
        this.servlet.setResponseStatusCode(HttpStatus.UNAUTHORIZED.code());
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        this.executeRequest(request, StringResponseHandler.createStringResponseHandler());
    }
}

