/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.EchoServlet;
import com.facebook.airlift.http.client.FileBodyGenerator;
import com.facebook.airlift.http.client.HeaderName;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpClientConfig;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.ResponseHandlerUtils;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.facebook.airlift.http.client.StatusResponseHandler;
import com.facebook.airlift.http.client.StringResponseHandler;
import com.facebook.airlift.http.client.UnexpectedResponseException;
import com.facebook.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.airlift.log.Logging;
import com.facebook.airlift.testing.Assertions;
import com.facebook.airlift.testing.Closeables;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public abstract class AbstractHttpClientTest {
    protected EchoServlet servlet;
    protected Server server;
    protected URI baseURI;
    private String scheme = "http";
    private String host = "127.0.0.1";
    private String keystore;
    private ExecutorService executor;

    protected AbstractHttpClientTest() {
    }

    protected AbstractHttpClientTest(String host, String keystore) {
        this.scheme = "https";
        this.host = host;
        this.keystore = keystore;
    }

    protected abstract HttpClientConfig createClientConfig();

    public abstract <T, E extends Exception> T executeRequest(Request var1, ResponseHandler<T, E> var2) throws Exception;

    public abstract <T, E extends Exception> T executeRequest(HttpClientConfig var1, Request var2, ResponseHandler<T, E> var3) throws Exception;

    @BeforeSuite
    public void setupSuite() {
        Logging.initialize();
    }

    @BeforeMethod
    public void abstractSetup() throws Exception {
        ServerConnector connector;
        this.servlet = new EchoServlet();
        Server server = new Server();
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setSendXPoweredBy(false);
        if (this.keystore != null) {
            httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory sslContextFactory = new SslContextFactory(this.keystore);
            sslContextFactory.setKeyStorePassword("changeit");
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, "http/1.1");
            connector = new ServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory(httpConfiguration)});
        } else {
            HttpConnectionFactory http1 = new HttpConnectionFactory(httpConfiguration);
            HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(httpConfiguration);
            connector = new ServerConnector(server, new ConnectionFactory[]{http1, http2c});
        }
        connector.setIdleTimeout(30000L);
        connector.setName(this.scheme);
        server.addConnector((Connector)connector);
        ServletHolder servletHolder = new ServletHolder((Servlet)this.servlet);
        ServletContextHandler context = new ServletContextHandler(0);
        context.setGzipHandler(new GzipHandler());
        context.addServlet(servletHolder, "/*");
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)context);
        server.setHandler((Handler)handlers);
        this.server = server;
        server.start();
        this.baseURI = new URI(this.scheme, null, this.host, connector.getLocalPort(), null, null, null);
    }

    @AfterMethod(alwaysRun=true)
    public void abstractTeardown() throws Exception {
        if (this.server != null) {
            this.server.setStopTimeout(3000L);
            this.server.stop();
        }
    }

    @Test(enabled=false, description="This takes over a minute to run")
    public void test100kGets() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere?query");
        Request request = Request.Builder.prepareGet().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").build();
        for (int i = 0; i < 100000; ++i) {
            try {
                int statusCode = ((StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
                Assert.assertEquals((int)statusCode, (int)200);
                continue;
            }
            catch (Exception e) {
                throw new Exception("Error on request " + i, e);
            }
        }
    }

    @Test(timeOut=5000L)
    public void testConnectTimeout() throws Exception {
        try (BackloggedServer server = new BackloggedServer();){
            HttpClientConfig config = this.createClientConfig();
            config.setConnectTimeout(new Duration(5.0, TimeUnit.MILLISECONDS));
            config.setIdleTimeout(new Duration(2.0, TimeUnit.SECONDS));
            Request request = Request.Builder.prepareGet().setUri(new URI(this.scheme, null, this.host, server.getPort(), "/", null, null)).build();
            long start = System.nanoTime();
            try {
                this.executeRequest(config, request, new CaptureExceptionResponseHandler());
                Assert.fail((String)"expected exception");
            }
            catch (CapturedException e) {
                Throwable t = e.getCause();
                if (!AbstractHttpClientTest.isConnectTimeout(t) && !(t instanceof ClosedChannelException)) {
                    Assert.fail((String)String.format("unexpected exception: [%s]", Throwables.getStackTraceAsString((Throwable)t)));
                }
                Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(300.0, TimeUnit.MILLISECONDS));
            }
        }
    }

    @Test(expectedExceptions={ConnectException.class})
    public void testConnectionRefused() throws Exception {
        int port = AbstractHttpClientTest.findUnusedPort();
        HttpClientConfig config = this.createClientConfig();
        config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
        Request request = Request.Builder.prepareGet().setUri(new URI(this.scheme, null, this.host, port, "/", null, null)).build();
        this.executeExceptionRequest(config, request);
    }

    @Test
    public void testConnectionRefusedWithDefaultingResponseExceptionHandler() throws Exception {
        int port = AbstractHttpClientTest.findUnusedPort();
        HttpClientConfig config = this.createClientConfig();
        config.setConnectTimeout(new Duration(5.0, TimeUnit.MILLISECONDS));
        Request request = Request.Builder.prepareGet().setUri(new URI(this.scheme, null, this.host, port, "/", null, null)).build();
        Object expected = new Object();
        Assert.assertEquals((Object)this.executeRequest(config, request, new DefaultOnExceptionResponseHandler(expected)), (Object)expected);
    }

    @Test(expectedExceptions={UnknownHostException.class, UnresolvedAddressException.class}, timeOut=10000L)
    public void testUnresolvableHost() throws Exception {
        String invalidHost = "nonexistent.invalid";
        AbstractHttpClientTest.assertUnknownHost(invalidHost);
        HttpClientConfig config = this.createClientConfig();
        config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
        Request request = Request.Builder.prepareGet().setUri(URI.create("http://" + invalidHost)).build();
        this.executeExceptionRequest(config, request);
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*port out of range.*")
    public void testBadPort() throws Exception {
        HttpClientConfig config = this.createClientConfig();
        config.setConnectTimeout(new Duration(5.0, TimeUnit.MILLISECONDS));
        Request request = Request.Builder.prepareGet().setUri(new URI(this.scheme, null, this.host, 70000, "/", null, null)).build();
        this.executeExceptionRequest(config, request);
    }

    @Test
    public void testDeleteMethod() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere");
        Request request = Request.Builder.prepareDelete().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").build();
        int statusCode = ((StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.getRequestMethod(), (String)"DELETE");
        Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)uri);
        Assert.assertEquals(this.servlet.getRequestHeaders("foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals(this.servlet.getRequestHeaders("dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
        Assert.assertEquals(this.servlet.getRequestHeaders("x-custom-filter"), (Collection)ImmutableList.of((Object)"custom value"));
    }

    @Test
    public void testErrorResponseBody() throws Exception {
        this.servlet.setResponseStatusCode(500);
        this.servlet.setResponseBody("body text");
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.executeRequest(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)500);
        Assert.assertEquals((String)response.getBody(), (String)"body text");
    }

    @Test
    public void testGetMethod() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere?query");
        Request request = Request.Builder.prepareGet().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").build();
        int statusCode = ((StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.getRequestMethod(), (String)"GET");
        if (this.servlet.getRequestUri().toString().endsWith("=")) {
            Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)new URI(uri + "="));
        } else {
            Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)uri);
        }
        Assert.assertEquals(this.servlet.getRequestHeaders("foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals(this.servlet.getRequestHeaders("dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
        Assert.assertEquals(this.servlet.getRequestHeaders("x-custom-filter"), (Collection)ImmutableList.of((Object)"custom value"));
    }

    @Test
    public void testResponseHeadersCaseInsensitive() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere");
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        Response response = this.executeRequest(request, new PassThroughResponseHandler());
        Assert.assertNotNull((Object)response.getHeader("date"));
        Assert.assertNotNull((Object)response.getHeader("DATE"));
        Assert.assertEquals((int)response.getHeaders("date").size(), (int)1);
        Assert.assertEquals((int)response.getHeaders("DATE").size(), (int)1);
    }

    @Test
    public void testQuotedSpace() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere?query=ab%20cd");
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        int statusCode = ((StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.getRequestMethod(), (String)"GET");
        Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)uri);
    }

    @Test
    public void testKeepAlive() throws Exception {
        URI uri = URI.create(this.baseURI.toASCIIString() + "/?remotePort=");
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        StatusResponseHandler.StatusResponse response1 = (StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Thread.sleep(1000L);
        StatusResponseHandler.StatusResponse response2 = (StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Thread.sleep(1000L);
        StatusResponseHandler.StatusResponse response3 = (StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertNotNull((Object)response1.getHeader("remotePort"));
        Assert.assertNotNull((Object)response2.getHeader("remotePort"));
        Assert.assertNotNull((Object)response3.getHeader("remotePort"));
        int port1 = Integer.parseInt(response1.getHeader("remotePort"));
        int port2 = Integer.parseInt(response2.getHeader("remotePort"));
        int port3 = Integer.parseInt(response3.getHeader("remotePort"));
        Assert.assertEquals((int)port2, (int)port1);
        Assert.assertEquals((int)port3, (int)port1);
        Assertions.assertBetweenInclusive((Comparable)Integer.valueOf(port1), (Comparable)Integer.valueOf(1024), (Comparable)Integer.valueOf(65535));
    }

    @Test
    public void testPostMethod() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere");
        Request request = Request.Builder.preparePost().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").build();
        int statusCode = ((StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.getRequestMethod(), (String)"POST");
        Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)uri);
        Assert.assertEquals(this.servlet.getRequestHeaders("foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals(this.servlet.getRequestHeaders("dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
        Assert.assertEquals(this.servlet.getRequestHeaders("x-custom-filter"), (Collection)ImmutableList.of((Object)"custom value"));
    }

    @Test
    public void testPutMethod() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere");
        Request request = Request.Builder.preparePut().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").build();
        int statusCode = ((StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.getRequestMethod(), (String)"PUT");
        Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)uri);
        Assert.assertEquals(this.servlet.getRequestHeaders("foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals(this.servlet.getRequestHeaders("dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
        Assert.assertEquals(this.servlet.getRequestHeaders("x-custom-filter"), (Collection)ImmutableList.of((Object)"custom value"));
    }

    @Test
    public void testPutMethodWithStaticBodyGenerator() throws Exception {
        this.testPutMethodWithStaticBodyGenerator(new byte[]{1, 2, 5});
        byte[] largeBody = new byte[0x100000];
        ThreadLocalRandom.current().nextBytes(largeBody);
        this.testPutMethodWithStaticBodyGenerator(largeBody);
    }

    public void testPutMethodWithStaticBodyGenerator(byte[] body) throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere");
        Request request = Request.Builder.preparePut().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((byte[])body)).build();
        int statusCode = ((StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.getRequestMethod(), (String)"PUT");
        Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)uri);
        Assert.assertEquals(this.servlet.getRequestHeaders("foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals(this.servlet.getRequestHeaders("dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
        Assert.assertEquals(this.servlet.getRequestHeaders("x-custom-filter"), (Collection)ImmutableList.of((Object)"custom value"));
        Assert.assertEquals((byte[])this.servlet.getRequestBytes(), (byte[])body);
    }

    @Test
    public void testPutMethodWithDynamicBodyGenerator() throws Exception {
        URI uri = this.baseURI.resolve("/road/to/nowhere");
        Request request = Request.Builder.preparePut().setUri(uri).addHeader("foo", "bar").addHeader("dupe", "first").addHeader("dupe", "second").setBodyGenerator(out -> {
            out.write(1);
            out.write(new byte[]{2, 5});
        }).build();
        int statusCode = ((StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.getRequestMethod(), (String)"PUT");
        Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)uri);
        Assert.assertEquals(this.servlet.getRequestHeaders("foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals(this.servlet.getRequestHeaders("dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
        Assert.assertEquals(this.servlet.getRequestHeaders("x-custom-filter"), (Collection)ImmutableList.of((Object)"custom value"));
        Assert.assertEquals((byte[])this.servlet.getRequestBytes(), (byte[])new byte[]{1, 2, 5});
    }

    @Test
    public void testPutMethodWithFileBodyGenerator() throws Exception {
        byte[] contents = "hello world".getBytes(StandardCharsets.UTF_8);
        File testFile = File.createTempFile("test", null);
        Files.write(testFile.toPath(), contents, new OpenOption[0]);
        URI uri = this.baseURI.resolve("/road/to/nowhere");
        Request request = Request.Builder.preparePut().setUri(uri).addHeader("Content-Type", "x-test").setBodyGenerator((BodyGenerator)new FileBodyGenerator(testFile.toPath())).build();
        int statusCode = ((StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
        Assert.assertEquals((int)statusCode, (int)200);
        Assert.assertEquals((String)this.servlet.getRequestMethod(), (String)"PUT");
        Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)uri);
        Assert.assertEquals(this.servlet.getRequestHeaders("Content-Type"), (Collection)ImmutableList.of((Object)"x-test"));
        Assert.assertEquals(this.servlet.getRequestHeaders("Content-Length"), (Collection)ImmutableList.of((Object)String.valueOf(contents.length)));
        Assert.assertEquals((byte[])this.servlet.getRequestBytes(), (byte[])contents);
        Assert.assertTrue((boolean)testFile.delete());
    }

    @Test(expectedExceptions={IOException.class, TimeoutException.class})
    public void testReadTimeout() throws Exception {
        HttpClientConfig config = this.createClientConfig().setIdleTimeout(new Duration(500.0, TimeUnit.MILLISECONDS));
        URI uri = URI.create(this.baseURI.toASCIIString() + "/?sleep=1000");
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        this.executeRequest(config, request, new ExceptionResponseHandler());
    }

    @Test
    public void testResponseBody() throws Exception {
        this.servlet.setResponseBody("body text");
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.executeRequest(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        Assert.assertEquals((String)response.getBody(), (String)"body text");
    }

    @Test
    public void testResponseBodyEmpty() throws Exception {
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        String body = ((StringResponseHandler.StringResponse)this.executeRequest(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler())).getBody();
        Assert.assertEquals((String)body, (String)"");
    }

    @Test
    public void testResponseHeader() throws Exception {
        this.servlet.addResponseHeader("foo", "bar");
        this.servlet.addResponseHeader("dupe", "first");
        this.servlet.addResponseHeader("dupe", "second");
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((Collection)response.getHeaders("foo"), (Collection)ImmutableList.of((Object)"bar"));
        Assert.assertEquals((Collection)response.getHeaders("dupe"), (Collection)ImmutableList.of((Object)"first", (Object)"second"));
    }

    @Test
    public void testResponseStatusCode() throws Exception {
        this.servlet.setResponseStatusCode(543);
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        int statusCode = ((StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusCode();
        Assert.assertEquals((int)statusCode, (int)543);
    }

    @Test
    public void testResponseStatusMessage() throws Exception {
        this.servlet.setResponseStatusMessage("message");
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        String statusMessage = ((StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler())).getStatusMessage();
        if (this.createClientConfig().isHttp2Enabled()) {
            Assert.assertNull((Object)statusMessage);
        } else {
            Assert.assertEquals((String)statusMessage, (String)"message");
        }
    }

    @Test
    public void testRequestHeaders() throws Exception {
        String basic = "Basic dGVzdDphYmM=";
        String bearer = "Bearer testxyz";
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).addHeader("X-Test", "xtest1").addHeader("X-Test", "xtest2").setHeader("User-Agent", "testagent").addHeader("Authorization", basic).addHeader("Authorization", bearer).build();
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        org.assertj.core.api.Assertions.assertThat(this.servlet.getRequestHeaders("X-Test")).containsExactly((Object[])new String[]{"xtest1", "xtest2"});
        org.assertj.core.api.Assertions.assertThat(this.servlet.getRequestHeaders("User-Agent")).containsExactly((Object[])new String[]{"testagent"});
        org.assertj.core.api.Assertions.assertThat(this.servlet.getRequestHeaders("Authorization")).containsExactly((Object[])new String[]{basic, bearer});
    }

    @Test
    public void testRedirectRequestHeaders() throws Exception {
        String basic = "Basic dGVzdDphYmM=";
        String bearer = "Bearer testxyz";
        Request request = Request.Builder.prepareGet().setUri(URI.create(this.baseURI.toASCIIString() + "/?redirect=/redirect")).addHeader("X-Test", "xtest1").addHeader("X-Test", "xtest2").setHeader("User-Agent", "testagent").addHeader("Authorization", basic).addHeader("Authorization", bearer).build();
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)URI.create(this.baseURI.toASCIIString() + "/redirect"));
        org.assertj.core.api.Assertions.assertThat(this.servlet.getRequestHeaders("X-Test")).containsExactly((Object[])new String[]{"xtest1", "xtest2"});
        org.assertj.core.api.Assertions.assertThat(this.servlet.getRequestHeaders("User-Agent")).containsExactly((Object[])new String[]{"testagent"});
        org.assertj.core.api.Assertions.assertThat(this.servlet.getRequestHeaders("Authorization")).isEmpty();
        request = Request.Builder.fromRequest((Request)request).setPreserveAuthorizationOnRedirect(true).build();
        response = (StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)URI.create(this.baseURI.toASCIIString() + "/redirect"));
        org.assertj.core.api.Assertions.assertThat(this.servlet.getRequestHeaders("X-Test")).containsExactly((Object[])new String[]{"xtest1", "xtest2"});
        org.assertj.core.api.Assertions.assertThat(this.servlet.getRequestHeaders("User-Agent")).containsExactly((Object[])new String[]{"testagent"});
        org.assertj.core.api.Assertions.assertThat(this.servlet.getRequestHeaders("Authorization")).containsExactly((Object[])new String[]{basic, bearer});
    }

    @Test
    public void testFollowRedirects() throws Exception {
        Request request = Request.Builder.prepareGet().setUri(URI.create(this.baseURI.toASCIIString() + "/test?redirect=/redirect")).build();
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)200);
        Assert.assertNull((Object)response.getHeader("Location"));
        Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)URI.create(this.baseURI.toASCIIString() + "/redirect"));
        request = Request.Builder.fromRequest((Request)request).setFollowRedirects(false).build();
        response = (StatusResponseHandler.StatusResponse)this.executeRequest(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)302);
        Assert.assertEquals((String)response.getHeader("Location"), (String)(this.baseURI.toASCIIString() + "/redirect"));
        Assert.assertEquals((Object)this.servlet.getRequestUri(), (Object)request.getUri());
    }

    @Test(expectedExceptions={UnexpectedResponseException.class})
    public void testThrowsUnexpectedResponseException() throws Exception {
        this.servlet.setResponseStatusCode(543);
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        this.executeRequest(request, new UnexpectedResponseStatusCodeHandler(200));
    }

    @Test
    public void testCompressionIsDisabled() throws Exception {
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        String body = ((StringResponseHandler.StringResponse)this.executeRequest(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler())).getBody();
        Assert.assertEquals((String)body, (String)"");
        Assert.assertFalse((boolean)this.servlet.getRequestHeaders().containsKey((Object)HeaderName.of((String)"Accept-Encoding")));
        String json = "{\"foo\":\"bar\",\"hello\":\"world\"}";
        Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(json.length()), (Comparable)Integer.valueOf(16));
        this.servlet.setResponseBody(json);
        this.servlet.addResponseHeader("Content-Type", "application/json");
        StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.executeRequest(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
        Assert.assertEquals((String)response.getHeader("Content-Type"), (String)"application/json");
        Assert.assertEquals((String)response.getBody(), (String)json);
    }

    @BeforeClass
    public final void setUp() throws Exception {
        this.executor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"test-%s"));
    }

    @AfterClass(alwaysRun=true)
    public final void tearDown() throws Exception {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Test(expectedExceptions={IOException.class, TimeoutException.class})
    public void testConnectNoRead() throws Exception {
        try (FakeServer fakeServer = new FakeServer(this.scheme, this.host, 0L, null, false);){
            HttpClientConfig config = this.createClientConfig();
            config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
            config.setIdleTimeout(new Duration(10.0, TimeUnit.MILLISECONDS));
            this.executeRequest(fakeServer, config);
        }
    }

    @Test(expectedExceptions={IOException.class})
    public void testConnectNoReadClose() throws Exception {
        try (FakeServer fakeServer = new FakeServer(this.scheme, this.host, 0L, null, true);){
            HttpClientConfig config = this.createClientConfig();
            config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
            config.setIdleTimeout(new Duration(5.0, TimeUnit.SECONDS));
            this.executeRequest(fakeServer, config);
        }
    }

    @Test(expectedExceptions={IOException.class, TimeoutException.class})
    public void testConnectReadIncomplete() throws Exception {
        try (FakeServer fakeServer = new FakeServer(this.scheme, this.host, 10L, null, false);){
            HttpClientConfig config = this.createClientConfig();
            config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
            config.setIdleTimeout(new Duration(10.0, TimeUnit.MILLISECONDS));
            this.executeRequest(fakeServer, config);
        }
    }

    @Test(expectedExceptions={IOException.class, TimeoutException.class})
    public void testConnectReadIncompleteClose() throws Exception {
        try (FakeServer fakeServer = new FakeServer(this.scheme, this.host, 10L, null, true);){
            HttpClientConfig config = this.createClientConfig();
            config.setConnectTimeout(new Duration(500.0, TimeUnit.MILLISECONDS));
            config.setIdleTimeout(new Duration(500.0, TimeUnit.MILLISECONDS));
            this.executeRequest(fakeServer, config);
        }
    }

    @Test(expectedExceptions={IOException.class})
    public void testConnectReadRequestClose() throws Exception {
        try (FakeServer fakeServer = new FakeServer(this.scheme, this.host, Long.MAX_VALUE, null, true);){
            HttpClientConfig config = this.createClientConfig();
            config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
            config.setIdleTimeout(new Duration(5.0, TimeUnit.SECONDS));
            this.executeRequest(fakeServer, config);
        }
    }

    @Test(expectedExceptions={Exception.class})
    public void testConnectReadRequestWriteJunkHangup() throws Exception {
        try (FakeServer fakeServer = new FakeServer(this.scheme, this.host, 10L, "THIS\nIS\nJUNK\n\n".getBytes(), false);){
            HttpClientConfig config = this.createClientConfig();
            config.setConnectTimeout(new Duration(5.0, TimeUnit.SECONDS));
            config.setIdleTimeout(new Duration(5.0, TimeUnit.SECONDS));
            this.executeRequest(fakeServer, config);
        }
    }

    @Test(expectedExceptions={CustomError.class})
    public void testHandlesUndeclaredThrowable() throws Exception {
        Request request = Request.Builder.prepareGet().setUri(this.baseURI).build();
        this.executeRequest(request, new ThrowErrorResponseHandler());
    }

    private void executeExceptionRequest(HttpClientConfig config, Request request) throws Exception {
        try {
            this.executeRequest(config, request, new CaptureExceptionResponseHandler());
            Assert.fail((String)"expected exception");
        }
        catch (CapturedException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), Exception.class);
            throw new RuntimeException(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequest(FakeServer fakeServer, HttpClientConfig config) throws Exception {
        this.executor.execute(fakeServer);
        long start = System.nanoTime();
        try {
            Request request = Request.Builder.prepareGet().setUri(fakeServer.getUri()).build();
            this.executeRequest(config, request, new ExceptionResponseHandler());
        }
        finally {
            Assertions.assertLessThan((Comparable)Duration.nanosSince((long)start), (Comparable)new Duration(1.0, TimeUnit.SECONDS), (String)"Expected request to finish quickly");
        }
    }

    private static int findUnusedPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    private static void assertUnknownHost(String host) {
        try {
            InetAddress.getByName(host);
            Assert.fail((String)("Expected UnknownHostException for host " + host));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private static boolean isConnectTimeout(Throwable t) {
        return t instanceof SocketTimeoutException || t instanceof SocketException;
    }

    public static <T, E extends Exception> T executeAsync(JettyHttpClient client, Request request, ResponseHandler<T, E> responseHandler) throws E {
        HttpClient.HttpResponseFuture future = null;
        try {
            future = client.executeAsync(request, responseHandler);
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected exception", (Throwable)e);
        }
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            if (e.getCause() instanceof Exception) {
                throw AbstractHttpClientTest.castThrowable(e.getCause());
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private static <E extends Exception> E castThrowable(Throwable t) {
        return (E)((Exception)t);
    }

    private static class BackloggedServer
    implements Closeable {
        private final List<Socket> clientSockets = new ArrayList<Socket>();
        private final ServerSocket serverSocket = new ServerSocket(0, 1, InetAddress.getByName("127.0.0.1"));
        private final SocketAddress localSocketAddress = this.serverSocket.getLocalSocketAddress();

        private BackloggedServer() throws IOException {
            int i;
            for (i = 0; i <= 256; ++i) {
                if (this.connect()) continue;
                return;
            }
            throw new SkipException(String.format("socket backlog is too large (%s connections accepted)", i));
        }

        @Override
        public void close() {
            this.clientSockets.forEach(xva$0 -> Closeables.closeQuietly((Closeable[])new Closeable[]{xva$0}));
            Closeables.closeQuietly((Closeable[])new Closeable[]{this.serverSocket});
        }

        private int getPort() {
            return this.serverSocket.getLocalPort();
        }

        private boolean connect() throws IOException {
            Socket socket = new Socket();
            this.clientSockets.add(socket);
            try {
                socket.connect(this.localSocketAddress, 5);
                return true;
            }
            catch (IOException e) {
                if (AbstractHttpClientTest.isConnectTimeout(e)) {
                    return false;
                }
                throw e;
            }
        }
    }

    private class DefaultOnExceptionResponseHandler
    implements ResponseHandler<Object, RuntimeException> {
        private final Object defaultObject;

        public DefaultOnExceptionResponseHandler(Object defaultObject) {
            this.defaultObject = defaultObject;
        }

        public Object handleException(Request request, Exception exception) throws RuntimeException {
            return this.defaultObject;
        }

        public Object handle(Request request, Response response) throws RuntimeException {
            throw new UnsupportedOperationException();
        }
    }

    public static class CapturedException
    extends Exception {
        public CapturedException(Exception exception) {
            super(exception);
        }
    }

    private static class CustomError
    extends Error {
        private CustomError() {
        }
    }

    public static class ThrowErrorResponseHandler
    implements ResponseHandler<String, Exception> {
        public String handleException(Request request, Exception exception) {
            throw new UnsupportedOperationException("not yet implemented", exception);
        }

        public String handle(Request request, Response response) {
            throw new CustomError();
        }
    }

    public static class CaptureExceptionResponseHandler
    implements ResponseHandler<String, CapturedException> {
        public String handleException(Request request, Exception exception) throws CapturedException {
            throw new CapturedException(exception);
        }

        public String handle(Request request, Response response) {
            return null;
        }
    }

    private static class UnexpectedResponseStatusCodeHandler
    implements ResponseHandler<Integer, RuntimeException> {
        private final int expectedStatusCode;

        UnexpectedResponseStatusCodeHandler(int expectedStatusCode) {
            this.expectedStatusCode = expectedStatusCode;
        }

        public Integer handleException(Request request, Exception exception) {
            throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
        }

        public Integer handle(Request request, Response response) throws RuntimeException {
            if (response.getStatusCode() != this.expectedStatusCode) {
                throw new UnexpectedResponseException(request, response);
            }
            return response.getStatusCode();
        }
    }

    private static class PassThroughResponseHandler
    implements ResponseHandler<Response, RuntimeException> {
        private PassThroughResponseHandler() {
        }

        public Response handleException(Request request, Exception exception) {
            throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
        }

        public Response handle(Request request, Response response) {
            return response;
        }
    }

    public static class ExceptionResponseHandler
    implements ResponseHandler<Void, Exception> {
        public Void handleException(Request request, Exception exception) throws Exception {
            throw exception;
        }

        public Void handle(Request request, Response response) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    private static class FakeServer
    implements Closeable,
    Runnable {
        private final ServerSocket serverSocket;
        private final long readBytes;
        private final byte[] writeBuffer;
        private final boolean closeConnectionImmediately;
        private final AtomicReference<Socket> connectionSocket = new AtomicReference();
        private final String scheme;
        private final String host;

        private FakeServer(String scheme, String host, long readBytes, byte[] writeBuffer, boolean closeConnectionImmediately) throws Exception {
            this.scheme = scheme;
            this.host = host;
            this.writeBuffer = writeBuffer;
            this.readBytes = readBytes;
            this.serverSocket = new ServerSocket(0, 50, InetAddress.getByName(host));
            this.closeConnectionImmediately = closeConnectionImmediately;
        }

        public URI getUri() {
            try {
                return new URI(this.scheme, null, this.host, this.serverSocket.getLocalPort(), "/", null, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                Socket connectionSocket = this.serverSocket.accept();
                this.connectionSocket.set(connectionSocket);
                if (this.readBytes > 0L) {
                    connectionSocket.setSoTimeout(5);
                    try {
                        InputStream inputStream = connectionSocket.getInputStream();
                        for (long bytesRead = 0L; bytesRead < this.readBytes; ++bytesRead) {
                            inputStream.read();
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        // empty catch block
                    }
                }
                if (this.writeBuffer != null) {
                    connectionSocket.getOutputStream().write(this.writeBuffer);
                }
                if (!this.closeConnectionImmediately) return;
            }
            catch (IOException e) {
                try {
                    throw new UncheckedIOException(e);
                }
                catch (Throwable throwable) {
                    if (!this.closeConnectionImmediately) throw throwable;
                    Closeables.closeQuietly((Closeable[])new Closeable[]{this.connectionSocket.get()});
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable[])new Closeable[]{this.connectionSocket.get()});
            return;
        }

        @Override
        public void close() throws IOException {
            Closeables.closeQuietly((Closeable[])new Closeable[]{this.connectionSocket.get()});
            this.serverSocket.close();
        }
    }
}

