/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.http.client.BasicAuthRequestFilter;
import com.facebook.airlift.http.client.Request;
import java.net.URI;
import java.util.function.Predicate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBasicAuthRequestFilter {
    @Test
    public void testBasicAuthentication() throws Exception {
        Predicate<Request> predicate = request -> request.getUri().getPath().startsWith("/private");
        BasicAuthRequestFilter filter = new BasicAuthRequestFilter(predicate, "Aladdin", "open sesame");
        Request publicResourceRequest = TestBasicAuthRequestFilter.createTestRequest("/public");
        Assert.assertNull((Object)filter.filterRequest(publicResourceRequest).getHeader("Authorization"));
        Request privateResourceRequest = TestBasicAuthRequestFilter.createTestRequest("/private");
        Assert.assertEquals((String)filter.filterRequest(privateResourceRequest).getHeader("Authorization"), (String)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
    }

    private static Request createTestRequest(String path) {
        return Request.Builder.prepareGet().setUri(URI.create("http://example.com" + path)).build();
    }
}

