/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.http.client.GatheringByteArrayInputStream;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGatheringByteArrayInputStream {
    @Test
    public void testNormal() {
        byte[] lastStringArray = "client".getBytes();
        byte[] lastArray = Arrays.copyOf(lastStringArray, lastStringArray.length + 32);
        System.arraycopy(lastStringArray, 0, lastArray, 0, lastStringArray.length);
        ImmutableList buffers = ImmutableList.of((Object)"hello ".getBytes(), (Object)"this ".getBytes(), (Object)"is ".getBytes(), (Object)"http ".getBytes(), (Object)lastArray);
        byte[] expectedAll = "hello this is http client".getBytes();
        byte[] expectedPartial = "hello this".getBytes();
        try (GatheringByteArrayInputStream in = new GatheringByteArrayInputStream((List)buffers, (long)expectedAll.length);){
            byte[] buffer = new byte[expectedAll.length + 32];
            Assert.assertEquals((int)in.read(buffer, 0, expectedPartial.length), (int)expectedPartial.length);
            TestGatheringByteArrayInputStream.assertByteArrayEquals(buffer, 0, expectedPartial, 0, expectedPartial.length);
            Assert.assertEquals((int)in.read(buffer, expectedPartial.length, buffer.length - expectedPartial.length), (int)(expectedAll.length - expectedPartial.length));
            TestGatheringByteArrayInputStream.assertByteArrayEquals(buffer, 0, expectedAll, 0, expectedAll.length);
            Assert.assertEquals((int)-1, (int)in.read(buffer, 0, expectedAll.length));
        }
    }

    @Test
    public void testSingleByteRead() {
        byte[] expected = "This is a test for single byte read".getBytes();
        ImmutableList buffers = ImmutableList.of((Object)"This ".getBytes(), (Object)"is ".getBytes(), (Object)"a test ".getBytes(), (Object)"for".getBytes(), (Object)" single byte read".getBytes());
        byte[] resultBuffer = new byte[expected.length];
        try (GatheringByteArrayInputStream in = new GatheringByteArrayInputStream((List)buffers, (long)expected.length);){
            for (int i = 0; i < expected.length; ++i) {
                resultBuffer[i] = (byte)in.read();
            }
            TestGatheringByteArrayInputStream.assertByteArrayEquals(resultBuffer, 0, expected, 0, expected.length);
            Assert.assertEquals((int)in.read(), (int)-1);
        }
    }

    @Test
    public void testNegativeSingleByteRead() {
        byte[] expected = new byte[]{-100};
        try (GatheringByteArrayInputStream in = new GatheringByteArrayInputStream((List)ImmutableList.of((Object)expected), (long)expected.length);){
            Assert.assertEquals((int)in.read(), (int)(expected[0] & 0xFF));
            Assert.assertEquals((int)in.read(), (int)-1);
        }
    }

    @Test
    public void testSkip() {
        byte[] allDataBytes = "Hello, this is http client package, and I am just a test for GatheringByteArrayInputStream".getBytes();
        int length = allDataBytes.length;
        try (GatheringByteArrayInputStream in = new GatheringByteArrayInputStream((List)ImmutableList.of((Object)Arrays.copyOfRange(allDataBytes, 0, length / 3), (Object)Arrays.copyOfRange(allDataBytes, length / 3, length / 3 + length / 2), (Object)Arrays.copyOfRange(allDataBytes, length / 3 + length / 2, length)), (long)length);){
            int skipped = length / 2;
            int firstPartLength = length / 4;
            int restPartLength = length - firstPartLength - skipped;
            byte[] actual = new byte[length - skipped + 10];
            Assert.assertEquals((int)in.read(actual, 0, firstPartLength), (int)firstPartLength);
            TestGatheringByteArrayInputStream.assertByteArrayEquals(actual, 0, allDataBytes, 0, firstPartLength);
            Assert.assertEquals((long)in.skip((long)skipped), (long)skipped);
            Assert.assertEquals((int)in.read(actual, firstPartLength, restPartLength + 10), (int)restPartLength);
            TestGatheringByteArrayInputStream.assertByteArrayEquals(actual, firstPartLength, allDataBytes, firstPartLength + skipped, restPartLength);
            Assert.assertEquals((long)in.skip(10L), (long)0L);
            Assert.assertEquals((int)in.read(), (int)-1);
        }
    }

    @Test
    public void testLargeData() {
        int copyBytes;
        int currentLength;
        int length = 123456789;
        Random random = new Random(0L);
        byte[] expected = new byte[length];
        random.nextBytes(expected);
        ArrayList<byte[]> buffers = new ArrayList<byte[]>();
        for (copyBytes = 0; copyBytes < length; copyBytes += currentLength) {
            currentLength = Math.min(length - copyBytes, random.nextInt(0x100000) + 64);
            buffers.add(Arrays.copyOfRange(expected, copyBytes, copyBytes + currentLength));
        }
        try (GatheringByteArrayInputStream in = new GatheringByteArrayInputStream(buffers, (long)length);){
            int currentLength2;
            byte[] actual = new byte[length];
            for (copyBytes = 0; copyBytes < length; copyBytes += currentLength2) {
                currentLength2 = Math.min(length - copyBytes, random.nextInt(0x100000) + 64);
                Assert.assertEquals((int)in.read(actual, copyBytes, currentLength2), (int)currentLength2);
                TestGatheringByteArrayInputStream.assertByteArrayEquals(actual, copyBytes, expected, copyBytes, currentLength2);
            }
            Assert.assertEquals((long)in.skip(100L), (long)0L);
            Assert.assertEquals((int)in.read(), (int)-1);
        }
    }

    private static void assertByteArrayEquals(byte[] actual, int actualStart, byte[] expected, int expectedStart, int length) {
        for (int i = 0; i < length; ++i) {
            Assert.assertEquals((byte)actual[i + actualStart], (byte)expected[i + expectedStart]);
        }
    }
}

