/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.http.client.HttpUriBuilder;
import com.google.common.net.HostAndPort;
import java.net.URI;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHttpUriBuilder {
    @Test
    public void testCreateFromUri() {
        URI original = URI.create("http://www.example.com:8081/a%20/%C3%A5?k=1&k=2&%C3%A5=3");
        Assert.assertEquals((Object)HttpUriBuilder.uriBuilderFrom((URI)original).build(), (Object)original);
    }

    @Test
    public void testBasic() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com");
    }

    @Test
    public void testWithPath() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").replacePath("/a/b/c").build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/a/b/c");
    }

    @Test
    public void testReplacePathWithRelative() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").replacePath("a/b/c").build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/a/b/c");
    }

    @Test
    public void testAppendToDefaultPath() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").appendPath("/a/b/c").build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/a/b/c");
    }

    @Test
    public void testAppendRelativePathToDefault() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").appendPath("a/b/c").build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/a/b/c");
    }

    @Test
    public void testAppendAbsolutePath() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").appendPath("/a/b/c").appendPath("/x/y/z").build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/a/b/c/x/y/z");
    }

    @Test
    public void testAppendRelativePath() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").appendPath("/a/b/c").appendPath("x/y/z").build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/a/b/c/x/y/z");
    }

    @Test
    public void testAppendPathElidesSlashes() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").appendPath("/a/b/c/").appendPath("/x/y/z").build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/a/b/c/x/y/z");
    }

    @Test
    public void testDoesNotStripTrailingSlash() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").appendPath("/a/b/c/").build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/a/b/c/");
    }

    @Test
    public void testFull() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").port(8081).replacePath("/a/b/c").replaceParameter("k", new String[]{"1"}).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com:8081/a/b/c?k=1");
    }

    @Test
    public void testAddParameter() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").replacePath("/").addParameter("k1", new String[]{"1"}).addParameter("k1", new String[]{"2"}).addParameter("k1", new String[]{"0"}).addParameter("k2", new String[]{"3"}).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/?k1=1&k1=2&k1=0&k2=3");
    }

    @Test
    public void testAddParameterMultivalued() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").replacePath("/").addParameter("k1", new String[]{"1", "2", "0"}).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/?k1=1&k1=2&k1=0");
    }

    @Test
    public void testAddEmptyParameter() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").addParameter("pretty", new String[0]).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/?pretty");
    }

    @Test
    public void testAddMultipleEmptyParameters() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").addParameter("pretty", new String[0]).addParameter("pretty", new String[0]).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/?pretty&pretty");
    }

    @Test
    public void testAddMixedEmptyAndNonEmptyParameters() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").addParameter("pretty", new String[0]).addParameter("pretty", new String[]{"true"}).addParameter("pretty", new String[0]).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/?pretty&pretty=true&pretty");
    }

    @Test
    public void testReplaceParameters() {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)URI.create("http://www.example.com:8081/?k1=1&k1=2&k2=3")).replaceParameter("k1", new String[]{"4"}).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com:8081/?k2=3&k1=4");
    }

    @Test
    public void testReplaceParameterMultivalued() {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)URI.create("http://www.example.com/?k1=1&k1=2&k2=3")).replaceParameter("k1", new String[]{"a", "b", "c"}).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/?k2=3&k1=a&k1=b&k1=c");
    }

    @Test
    public void testReplacePort() {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)URI.create("http://www.example.com:8081/")).port(80).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com:80/");
    }

    @Test
    public void testDefaultPort() {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)URI.create("http://www.example.com:8081")).defaultPort().build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com");
    }

    @Test
    public void testHostWithIpv6() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("FEDC:BA98:7654:3210:FEDC:BA98:7654:3210").port(8081).replacePath("/a/b").build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:8081/a/b");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="host starts with a bracket")
    public void testHostWithBracketedIpv6() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]").port(8081).replacePath("/a/b").build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:8081/a/b");
    }

    @Test
    public void testHostAndPortWithHostPort() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").port(8888).hostAndPort(HostAndPort.fromParts((String)"example.com", (int)8081)).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://example.com:8081");
    }

    @Test
    public void testHostAndPortWithHostOnly() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").port(8888).hostAndPort(HostAndPort.fromString((String)"example.com")).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://example.com");
    }

    @Test
    public void testHostAndPortWithBracketedIpv6() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").port(8888).hostAndPort(HostAndPort.fromParts((String)"[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]", (int)8081)).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:8081");
    }

    @Test
    public void testHostAndPortWithUnbracketedIpv6() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").port(8888).hostAndPort(HostAndPort.fromParts((String)"FEDC:BA98:7654:3210:FEDC:BA98:7654:3210", (int)8081)).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:8081");
    }

    @Test
    public void testHostAndPortWithUnbracketedIpv6String() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").port(8888).hostAndPort(HostAndPort.fromString((String)"FEDC:BA98:7654:3210:FEDC:BA98:7654:3210")).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]");
    }

    @Test
    public void testEncodesPath() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").replacePath("/`#%^{}|[]<>?\u00e1\u00e9\u00ed\u00f3\u00fa").build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/%60%23%25%5E%7B%7D%7C%5B%5D%3C%3E%3F%C3%A1%C3%A9%C3%AD%C3%B3%C3%BA");
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp=".*scheme.*")
    public void testVerifiesSchemeIsSet() {
        HttpUriBuilder.uriBuilder().build();
    }

    @Test
    public void testQueryParametersNoPath() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").addParameter("a", new String[]{"1"}).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/?a=1");
    }

    @Test
    public void testEncodesQueryParameters() {
        URI uri = HttpUriBuilder.uriBuilder().scheme("http").host("www.example.com").replaceParameter("a", new String[]{"&"}).build();
        Assert.assertEquals((String)uri.toASCIIString(), (String)"http://www.example.com/?a=%26");
    }

    @Test
    public void testAcceptsHttpAndHttpScheme() {
        HttpUriBuilder.uriBuilderFrom((URI)URI.create("http://example.com"));
        HttpUriBuilder.uriBuilderFrom((URI)URI.create("https://example.com"));
        HttpUriBuilder.uriBuilderFrom((URI)URI.create("HTTP://example.com"));
        HttpUriBuilder.uriBuilderFrom((URI)URI.create("HTTPS://example.com"));
    }
}

