/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.google.common.collect.ImmutableListMultimap;
import java.net.URI;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRequestBuilder {
    public static final BodyGenerator NULL_BODY_GENERATOR = StaticBodyGenerator.createStaticBodyGenerator((byte[])new byte[0]);

    @Test
    public void testRequestBuilder() {
        Request request = TestRequestBuilder.createRequest();
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((Object)request.getBodyGenerator(), (Object)NULL_BODY_GENERATOR);
        Assert.assertEquals((Object)request.getUri(), (Object)URI.create("http://example.com"));
        Assert.assertEquals((Object)request.getHeaders(), (Object)ImmutableListMultimap.of((Object)"newheader", (Object)"withvalue", (Object)"anotherheader", (Object)"anothervalue"));
        Assert.assertFalse((boolean)request.isFollowRedirects());
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Cannot make requests to HTTP port 0")
    public void testCannotBuildRequestToIllegalPort() throws Exception {
        Request.Builder.prepareGet().setUri(URI.create("http://example.com:0/"));
    }

    @Test
    public void testBuilderFromRequest() {
        Request request = TestRequestBuilder.createRequest();
        Assert.assertEquals((Object)Request.Builder.fromRequest((Request)request).build(), (Object)request);
    }

    private static Request createRequest() {
        return Request.Builder.prepareGet().setUri(URI.create("http://example.com")).addHeader("newheader", "withvalue").addHeader("anotherheader", "anothervalue").setBodyGenerator(NULL_BODY_GENERATOR).setFollowRedirects(false).setPreserveAuthorizationOnRedirect(true).build();
    }
}

