/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.jetty;

import com.facebook.airlift.http.client.AbstractHttpClientTest;
import com.facebook.airlift.http.client.HttpClientConfig;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.TestingRequestFilter;
import com.facebook.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.airlift.http.client.spnego.KerberosConfig;
import com.facebook.airlift.testing.Closeables;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class TestAsyncJettyHttpClient
extends AbstractHttpClientTest {
    private JettyHttpClient httpClient;

    @BeforeClass
    public void setUpHttpClient() {
        this.httpClient = new JettyHttpClient("test-shared", this.createClientConfig(), new KerberosConfig(), (Iterable)ImmutableList.of((Object)new TestingRequestFilter()));
    }

    @AfterClass(alwaysRun=true)
    public void tearDownHttpClient() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.httpClient});
    }

    @Override
    protected HttpClientConfig createClientConfig() {
        return new HttpClientConfig().setHttp2Enabled(false);
    }

    @Override
    public <T, E extends Exception> T executeRequest(Request request, ResponseHandler<T, E> responseHandler) throws Exception {
        return TestAsyncJettyHttpClient.executeAsync(this.httpClient, request, responseHandler);
    }

    @Override
    public <T, E extends Exception> T executeRequest(HttpClientConfig config, Request request, ResponseHandler<T, E> responseHandler) throws Exception {
        try (JettyHttpClient client = new JettyHttpClient("test-private", config, new KerberosConfig(), (Iterable)ImmutableList.of((Object)new TestingRequestFilter()));){
            T t = TestAsyncJettyHttpClient.executeAsync(client, request, responseHandler);
            return t;
        }
    }
}

