/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.jetty;

import com.facebook.airlift.http.client.jetty.ChunkedBytesContentProvider;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestChunkedBytesContentProvider {
    @Test
    public void testGetLength() {
        ChunkedBytesContentProvider contentProvider = new ChunkedBytesContentProvider(new byte[]{1, 2, 3});
        Assert.assertEquals((long)contentProvider.getLength(), (long)3L);
        contentProvider = new ChunkedBytesContentProvider(new byte[0]);
        Assert.assertEquals((long)contentProvider.getLength(), (long)0L);
    }

    @Test
    public void testIterator() {
        ChunkedBytesContentProvider contentProvider = new ChunkedBytesContentProvider(new byte[0], 2);
        Iterator iterator = contentProvider.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        contentProvider = new ChunkedBytesContentProvider(new byte[]{1}, 2);
        iterator = contentProvider.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(iterator.next(), (Object)ByteBuffer.wrap(new byte[]{1}));
        Assert.assertFalse((boolean)iterator.hasNext());
        contentProvider = new ChunkedBytesContentProvider(new byte[]{1, 2}, 2);
        iterator = contentProvider.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(iterator.next(), (Object)ByteBuffer.wrap(new byte[]{1, 2}));
        Assert.assertFalse((boolean)iterator.hasNext());
        contentProvider = new ChunkedBytesContentProvider(new byte[]{1, 2, 3}, 2);
        iterator = contentProvider.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(iterator.next(), (Object)ByteBuffer.wrap(new byte[]{1, 2}));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(iterator.next(), (Object)ByteBuffer.wrap(new byte[]{3}));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIsReproducible() {
        byte[] bytes = new byte[]{1, 2, 3};
        ChunkedBytesContentProvider contentProvider = new ChunkedBytesContentProvider(bytes);
        Assert.assertTrue((boolean)contentProvider.isReproducible());
        Iterator iterator = contentProvider.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(iterator.next(), (Object)ByteBuffer.wrap(bytes));
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertThrows(NoSuchElementException.class, iterator::next);
        iterator = contentProvider.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(iterator.next(), (Object)ByteBuffer.wrap(bytes));
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertThrows(NoSuchElementException.class, iterator::next);
    }
}

