/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.jetty;

import com.facebook.airlift.http.client.AbstractHttpClientTest;
import com.facebook.airlift.http.client.HttpClientConfig;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.TestingRequestFilter;
import com.facebook.airlift.http.client.TestingSocksProxy;
import com.facebook.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.airlift.http.client.spnego.KerberosConfig;
import com.facebook.airlift.testing.Closeables;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJettyHttpClientSocksProxy
extends AbstractHttpClientTest {
    private JettyHttpClient httpClient;
    private TestingSocksProxy testingSocksProxy;

    @BeforeClass
    public void setUpHttpClient() throws IOException {
        this.testingSocksProxy = new TestingSocksProxy().start();
        this.httpClient = new JettyHttpClient("test-shared", this.createClientConfig(), new KerberosConfig(), (Iterable)ImmutableList.of((Object)new TestingRequestFilter()));
    }

    @AfterClass(alwaysRun=true)
    public void tearDownHttpClient() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.httpClient});
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.testingSocksProxy});
    }

    @Override
    protected HttpClientConfig createClientConfig() {
        return new HttpClientConfig().setHttp2Enabled(false).setSocksProxy(this.testingSocksProxy.getHostAndPort());
    }

    @Override
    public <T, E extends Exception> T executeRequest(Request request, ResponseHandler<T, E> responseHandler) throws Exception {
        return (T)this.httpClient.execute(request, responseHandler);
    }

    @Override
    public <T, E extends Exception> T executeRequest(HttpClientConfig config, Request request, ResponseHandler<T, E> responseHandler) throws Exception {
        config.setSocksProxy(this.testingSocksProxy.getHostAndPort());
        try (JettyHttpClient client = new JettyHttpClient("test-private", config, new KerberosConfig(), (Iterable)ImmutableList.of((Object)new TestingRequestFilter()));){
            Object object = client.execute(request, responseHandler);
            return (T)object;
        }
    }

    @Override
    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp=".*SOCKS4 .*")
    public void testBadPort() throws Exception {
        super.testBadPort();
    }

    @Override
    @Test(enabled=false)
    public void testConnectTimeout() throws Exception {
        super.testConnectTimeout();
    }

    @Override
    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp=".*SOCKS4 .*")
    public void testConnectionRefused() throws Exception {
        super.testConnectionRefused();
    }

    @Override
    @Test(expectedExceptions={IOException.class}, expectedExceptionsMessageRegExp=".*SOCKS4 .*")
    public void testUnresolvableHost() throws Exception {
        super.testUnresolvableHost();
    }
}

