/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.http.client.HeaderName;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class EchoServlet
extends HttpServlet {
    private String requestMethod;
    private URI requestUri;
    private final ListMultimap<HeaderName, String> requestHeaders = ArrayListMultimap.create();
    private byte[] requestBytes;
    private int responseStatusCode = 200;
    private String responseStatusMessage;
    private final ListMultimap<String, String> responseHeaders = ArrayListMultimap.create();
    private String responseBody;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.requestMethod = request.getMethod();
        this.requestUri = URI.create(request.getRequestURL().toString());
        if (request.getQueryString() != null) {
            this.requestUri = URI.create(this.requestUri.toASCIIString() + "?" + request.getQueryString());
        }
        this.requestHeaders.clear();
        for (String name : Collections.list(request.getHeaderNames())) {
            this.requestHeaders.putAll((Object)HeaderName.of((String)name), Collections.list(request.getHeaders(name)));
        }
        this.requestBytes = ByteStreams.toByteArray((InputStream)request.getInputStream());
        if (this.responseStatusMessage != null) {
            response.sendError(this.responseStatusCode, this.responseStatusMessage);
        } else {
            response.setStatus(this.responseStatusCode);
        }
        for (Map.Entry entry : this.responseHeaders.entries()) {
            response.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            if (request.getParameter("sleep") != null) {
                Thread.sleep(Long.parseLong(request.getParameter("sleep")));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        if (request.getParameter("remotePort") != null) {
            response.addHeader("remotePort", String.valueOf(request.getRemotePort()));
        }
        if (request.getParameter("redirect") != null) {
            response.sendRedirect(request.getParameter("redirect"));
        }
        if (this.responseBody != null) {
            response.getOutputStream().write(this.responseBody.getBytes(StandardCharsets.UTF_8));
        }
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    public ListMultimap<HeaderName, String> getRequestHeaders() {
        return ImmutableListMultimap.copyOf(this.requestHeaders);
    }

    public List<String> getRequestHeaders(String name) {
        return this.requestHeaders.get((Object)HeaderName.of((String)name));
    }

    public byte[] getRequestBytes() {
        return (byte[])this.requestBytes.clone();
    }

    public void setResponseStatusCode(int responseStatusCode) {
        this.responseStatusCode = responseStatusCode;
    }

    public void setResponseStatusMessage(String responseStatusMessage) {
        this.responseStatusMessage = responseStatusMessage;
    }

    public void addResponseHeader(String name, String value) {
        this.responseHeaders.put((Object)name, (Object)value);
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }
}

