/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.http.client.FullJsonResponseHandler;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.testing.TestingResponse;
import com.facebook.airlift.json.JsonCodec;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.net.MediaType;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFullJsonResponseHandler {
    private final JsonCodec<User> codec = JsonCodec.jsonCodec(User.class);
    private final FullJsonResponseHandler<User> handler = FullJsonResponseHandler.createFullJsonResponseHandler(this.codec);

    @Test
    public void testValidJson() {
        User user = new User("Joe", 25);
        String json = this.codec.toJson((Object)user);
        FullJsonResponseHandler.JsonResponse response = this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)json));
        Assert.assertTrue((boolean)response.hasValue());
        Assert.assertEquals((byte[])response.getJsonBytes(), (byte[])json.getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((String)response.getJson(), (String)json);
        Assert.assertEquals((String)((User)response.getValue()).getName(), (String)user.getName());
        Assert.assertEquals((int)((User)response.getValue()).getAge(), (int)user.getAge());
        Assert.assertNotSame((Object)response.getJson(), (Object)response.getJson());
        Assert.assertNotSame((Object)response.getJsonBytes(), (Object)response.getJsonBytes());
        Assert.assertNotSame((Object)response.getResponseBytes(), (Object)response.getResponseBytes());
        Assert.assertNotSame((Object)response.getResponseBody(), (Object)response.getResponseBody());
        Assert.assertEquals((byte[])response.getResponseBytes(), (byte[])response.getJsonBytes());
        Assert.assertEquals((String)response.getResponseBody(), (String)response.getJson());
    }

    @Test
    public void testInvalidJson() {
        String json = "{\"age\": \"foo\"}";
        FullJsonResponseHandler.JsonResponse response = this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)json));
        Assert.assertFalse((boolean)response.hasValue());
        Assert.assertEquals((String)response.getException().getMessage(), (String)String.format("Unable to create %s from JSON response:\n[%s]", User.class, json));
        Assert.assertTrue((boolean)(response.getException().getCause() instanceof IllegalArgumentException));
        Assert.assertEquals((String)response.getException().getCause().getMessage(), (String)"Invalid JSON bytes for [simple type, class com.facebook.airlift.http.client.TestFullJsonResponseHandler$User]");
        Assert.assertEquals((byte[])response.getJsonBytes(), (byte[])json.getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((String)response.getJson(), (String)json);
        Assert.assertEquals((byte[])response.getResponseBytes(), (byte[])response.getJsonBytes());
        Assert.assertEquals((String)response.getResponseBody(), (String)response.getJson());
    }

    @Test
    public void testInvalidJsonGetValue() {
        String json = "{\"age\": \"foo\"}";
        FullJsonResponseHandler.JsonResponse response = this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)json));
        try {
            response.getValue();
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Response does not contain a JSON value");
            Assert.assertEquals((Object)e.getCause(), (Object)response.getException());
            Assert.assertEquals((byte[])response.getJsonBytes(), (byte[])json.getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)response.getJson(), (String)json);
            Assert.assertEquals((byte[])response.getResponseBytes(), (byte[])response.getJsonBytes());
            Assert.assertEquals((String)response.getResponseBody(), (String)response.getJson());
        }
    }

    @Test
    public void testNonJsonResponse() {
        FullJsonResponseHandler.JsonResponse response = this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"hello"));
        Assert.assertFalse((boolean)response.hasValue());
        Assert.assertNull((Object)response.getException());
        Assert.assertNull((Object)response.getJson());
        Assert.assertNull((Object)response.getJsonBytes());
        Assert.assertEquals((byte[])response.getResponseBytes(), (byte[])"hello".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((String)response.getResponseBody(), (String)"hello");
    }

    @Test
    public void testMissingContentType() {
        FullJsonResponseHandler.JsonResponse response = this.handler.handle(null, (Response)new TestingResponse(HttpStatus.OK, (ListMultimap)ImmutableListMultimap.of(), "hello".getBytes(StandardCharsets.UTF_8)));
        Assert.assertFalse((boolean)response.hasValue());
        Assert.assertNull((Object)response.getException());
        Assert.assertNull((Object)response.getJson());
        Assert.assertNull((Object)response.getJsonBytes());
        Assert.assertEquals((byte[])response.getResponseBytes(), (byte[])"hello".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((String)response.getResponseBody(), (String)"hello");
        Assert.assertTrue((boolean)response.getHeaders().isEmpty());
    }

    @Test
    public void testJsonErrorResponse() {
        String json = "{\"error\": true}";
        FullJsonResponseHandler.JsonResponse response = this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (MediaType)MediaType.JSON_UTF_8, (String)json));
        Assert.assertTrue((boolean)response.hasValue());
        Assert.assertEquals((String)response.getJson(), (String)json);
        Assert.assertEquals((byte[])response.getJsonBytes(), (byte[])json.getBytes(StandardCharsets.UTF_8));
        Assert.assertNull((Object)((User)response.getValue()).getName());
        Assert.assertEquals((int)((User)response.getValue()).getAge(), (int)0);
        Assert.assertEquals((byte[])response.getResponseBytes(), (byte[])response.getJsonBytes());
        Assert.assertEquals((String)response.getResponseBody(), (String)response.getJson());
    }

    public static class User {
        private final String name;
        private final int age;

        @JsonCreator
        public User(@JsonProperty(value="name") String name, @JsonProperty(value="age") int age) {
            this.name = name;
            this.age = age;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public int getAge() {
            return this.age;
        }
    }
}

