/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpClientBinder;
import com.facebook.airlift.http.client.HttpRequestFilter;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.TestingRequestFilter;
import com.facebook.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.airlift.testing.Assertions;
import com.facebook.airlift.tracetoken.TraceTokenModule;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.units.Duration;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.inject.Qualifier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHttpClientBinder {
    @Test
    public void testConfigDefaults() throws Exception {
        Injector injector = new Bootstrap(new Module[]{binder -> HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("foo", FooClient.class).withConfigDefaults(config -> config.setRequestTimeout(new Duration(33.0, TimeUnit.MINUTES))), new TraceTokenModule()}).quiet().initialize();
        JettyHttpClient httpClient = (JettyHttpClient)injector.getInstance(Key.get(HttpClient.class, FooClient.class));
        Assert.assertEquals((long)httpClient.getRequestTimeoutMillis(), (long)TimeUnit.MINUTES.toMillis(33L));
    }

    @Test
    public void testGlobalFilterBinding() throws Exception {
        HttpRequestFilter globalFilter1 = r -> r;
        HttpRequestFilter globalFilter2 = r -> r;
        HttpRequestFilter filter1 = r -> r;
        HttpRequestFilter filter2 = r -> r;
        Injector injector = new Bootstrap(new Module[]{binder -> {
            HttpClientBinder.httpClientBinder((Binder)binder).addGlobalFilterBinding().toInstance((Object)globalFilter1);
            HttpClientBinder.httpClientBinder((Binder)binder).bindGlobalFilter(globalFilter2);
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("foo", FooClient.class).addFilterBinding().toInstance((Object)filter1);
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("bar", BarClient.class).addFilterBinding().toInstance((Object)filter2);
        }, new TraceTokenModule()}).quiet().initialize();
        JettyHttpClient fooClient = (JettyHttpClient)injector.getInstance(Key.get(HttpClient.class, FooClient.class));
        TestHttpClientBinder.assertFilterCount((HttpClient)fooClient, 3);
        Assert.assertEquals(fooClient.getRequestFilters().get(0), (Object)globalFilter1);
        Assert.assertEquals(fooClient.getRequestFilters().get(1), (Object)globalFilter2);
        Assert.assertEquals(fooClient.getRequestFilters().get(2), (Object)filter1);
        JettyHttpClient barClient = (JettyHttpClient)injector.getInstance(Key.get(HttpClient.class, BarClient.class));
        TestHttpClientBinder.assertFilterCount((HttpClient)barClient, 3);
        Assert.assertEquals(barClient.getRequestFilters().get(0), (Object)globalFilter1);
        Assert.assertEquals(barClient.getRequestFilters().get(1), (Object)globalFilter2);
        Assert.assertEquals(barClient.getRequestFilters().get(2), (Object)filter2);
    }

    @Test
    public void testBindingMultipleFiltersAndClients() throws Exception {
        Injector injector = new Bootstrap(new Module[]{binder -> {
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("foo", FooClient.class).withFilter(TestingRequestFilter.class).withFilter(AnotherHttpRequestFilter.class).withTracing();
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("bar", BarClient.class).withFilter(TestingRequestFilter.class).addFilterBinding().to(AnotherHttpRequestFilter.class);
        }, new TraceTokenModule()}).quiet().initialize();
        TestHttpClientBinder.assertFilterCount((HttpClient)injector.getInstance(Key.get(HttpClient.class, FooClient.class)), 3);
        TestHttpClientBinder.assertFilterCount((HttpClient)injector.getInstance(Key.get(HttpClient.class, BarClient.class)), 2);
    }

    @Test
    public void testBindClientWithFilter() throws Exception {
        Injector injector = new Bootstrap(new Module[]{binder -> HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("foo", FooClient.class).withFilter(TestingRequestFilter.class).withFilter(AnotherHttpRequestFilter.class).withTracing(), new TraceTokenModule()}).quiet().initialize();
        HttpClient httpClient = (HttpClient)injector.getInstance(Key.get(HttpClient.class, FooClient.class));
        TestHttpClientBinder.assertFilterCount(httpClient, 3);
    }

    @Test
    public void testWithoutFilters() throws Exception {
        Injector injector = new Bootstrap(new Module[]{binder -> HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("foo", FooClient.class)}).quiet().initialize();
        Assert.assertNotNull((Object)injector.getInstance(Key.get(HttpClient.class, FooClient.class)));
    }

    @Test
    public void testAliases() throws Exception {
        Injector injector = new Bootstrap(new Module[]{binder -> HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("foo", FooClient.class).withAlias(FooAlias1.class).withAliases((Collection)ImmutableList.of(FooAlias2.class, FooAlias3.class))}).quiet().initialize();
        HttpClient client = (HttpClient)injector.getInstance(Key.get(HttpClient.class, FooClient.class));
        Assert.assertSame((Object)injector.getInstance(Key.get(HttpClient.class, FooAlias1.class)), (Object)client);
        Assert.assertSame((Object)injector.getInstance(Key.get(HttpClient.class, FooAlias2.class)), (Object)client);
        Assert.assertSame((Object)injector.getInstance(Key.get(HttpClient.class, FooAlias3.class)), (Object)client);
    }

    @Test
    public void testBindClientWithAliases() throws Exception {
        Injector injector = new Bootstrap(new Module[]{binder -> HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("foo", FooClient.class).withAlias(FooAlias1.class).withAlias(FooAlias2.class)}).quiet().initialize();
        HttpClient client = (HttpClient)injector.getInstance(Key.get(HttpClient.class, FooClient.class));
        Assert.assertSame((Object)injector.getInstance(Key.get(HttpClient.class, FooAlias1.class)), (Object)client);
        Assert.assertSame((Object)injector.getInstance(Key.get(HttpClient.class, FooAlias2.class)), (Object)client);
    }

    @Test
    public void testMultipleClients() throws Exception {
        Injector injector = new Bootstrap(new Module[]{binder -> {
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("foo", FooClient.class);
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("bar", BarClient.class);
        }}).quiet().initialize();
        HttpClient fooClient = (HttpClient)injector.getInstance(Key.get(HttpClient.class, FooClient.class));
        HttpClient barClient = (HttpClient)injector.getInstance(Key.get(HttpClient.class, BarClient.class));
        Assert.assertNotSame((Object)fooClient, (Object)barClient);
    }

    @Test
    public void testClientShutdown() throws Exception {
        Injector injector = new Bootstrap(new Module[]{binder -> {
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("foo", FooClient.class);
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("bar", BarClient.class);
        }}).quiet().initialize();
        HttpClient fooClient = (HttpClient)injector.getInstance(Key.get(HttpClient.class, FooClient.class));
        HttpClient barClient = (HttpClient)injector.getInstance(Key.get(HttpClient.class, BarClient.class));
        Assert.assertFalse((boolean)fooClient.isClosed());
        Assert.assertFalse((boolean)barClient.isClosed());
        ((LifeCycleManager)injector.getInstance(LifeCycleManager.class)).stop();
        Assert.assertTrue((boolean)fooClient.isClosed());
        Assert.assertTrue((boolean)barClient.isClosed());
    }

    private static void assertFilterCount(HttpClient httpClient, int filterCount) {
        Assert.assertNotNull((Object)httpClient);
        Assertions.assertInstanceOf((Object)httpClient, JettyHttpClient.class);
        Assert.assertEquals((int)((JettyHttpClient)httpClient).getRequestFilters().size(), (int)filterCount);
    }

    public static class AnotherHttpRequestFilter
    implements HttpRequestFilter {
        public Request filterRequest(Request request) {
            return request;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @Qualifier
    public static @interface BarClient {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @Qualifier
    public static @interface FooAlias3 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @Qualifier
    public static @interface FooAlias2 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @Qualifier
    public static @interface FooAlias1 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @Qualifier
    public static @interface FooClient {
    }
}

