/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client;

import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.TestFullJsonResponseHandler;
import com.facebook.airlift.http.client.UnexpectedResponseException;
import com.facebook.airlift.http.client.testing.TestingResponse;
import com.facebook.airlift.json.JsonCodec;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.net.MediaType;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJsonResponseHandler {
    private final JsonCodec<TestFullJsonResponseHandler.User> codec = JsonCodec.jsonCodec(TestFullJsonResponseHandler.User.class);
    private final JsonResponseHandler<TestFullJsonResponseHandler.User> handler = JsonResponseHandler.createJsonResponseHandler(this.codec);

    @Test
    public void testValidJson() {
        TestFullJsonResponseHandler.User user = new TestFullJsonResponseHandler.User("Joe", 25);
        TestFullJsonResponseHandler.User response = (TestFullJsonResponseHandler.User)this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)this.codec.toJson((Object)user)));
        Assert.assertEquals((String)response.getName(), (String)user.getName());
        Assert.assertEquals((int)response.getAge(), (int)user.getAge());
    }

    @Test
    public void testInvalidJson() {
        String json = "{\"age\": \"foo\"}";
        try {
            this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)json));
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)String.format("Unable to create %s from JSON response:\n[%s]", TestFullJsonResponseHandler.User.class, json));
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            Assert.assertEquals((String)e.getCause().getMessage(), (String)"Invalid JSON bytes for [simple type, class com.facebook.airlift.http.client.TestFullJsonResponseHandler$User]");
        }
    }

    @Test(expectedExceptions={UnexpectedResponseException.class}, expectedExceptionsMessageRegExp="Expected application/json response from server but got text/plain; charset=utf-8")
    public void testNonJsonResponse() {
        this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"hello"));
    }

    @Test(expectedExceptions={UnexpectedResponseException.class}, expectedExceptionsMessageRegExp="Content-Type is not set for response")
    public void testMissingContentType() {
        this.handler.handle(null, (Response)new TestingResponse(HttpStatus.OK, (ListMultimap)ImmutableListMultimap.of(), "hello".getBytes(StandardCharsets.UTF_8)));
    }

    @Test(expectedExceptions={UnexpectedResponseException.class})
    public void testJsonErrorResponse() {
        String json = "{\"error\": true}";
        this.handler.handle(null, TestingResponse.mockResponse((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (MediaType)MediaType.JSON_UTF_8, (String)json));
    }
}

