/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.jetty;

import com.facebook.airlift.http.client.jetty.DefaultHttpClientLogger;
import com.facebook.airlift.http.client.jetty.HttpClientLogger;
import com.facebook.airlift.http.client.jetty.HttpRequestEvent;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.File;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.Fields;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestHttpClientLogger {
    private static final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());
    private File file;

    @BeforeMethod
    public void setup() throws IOException {
        this.file = File.createTempFile(this.getClass().getName(), ".log");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws IOException {
        if (this.file.exists() && !this.file.delete()) {
            throw new IOException("Error deleting " + this.file.getAbsolutePath());
        }
    }

    @Test
    public void testClientLog() throws Exception {
        String method = "GET";
        URI uri = new URI("http://www.google.com");
        int status = 200;
        long responseSize = 345L;
        long requestTimestamp = System.currentTimeMillis();
        HttpFields headers = new HttpFields();
        headers.add("X-Airlift-Tracetoken", "test-token");
        TestRequest request = new TestRequest(HttpVersion.HTTP_2, method, uri, headers);
        TestResponse response = new TestResponse(status);
        DefaultHttpClientLogger logger = new DefaultHttpClientLogger(this.file.getAbsolutePath(), 1, 256, new DataSize(1.0, DataSize.Unit.MEGABYTE), new Duration(10.0, TimeUnit.SECONDS), Long.MAX_VALUE, false);
        long queueTime = TimeUnit.MILLISECONDS.toNanos(1L);
        long requestCreate = System.nanoTime();
        long requestBegin = requestCreate + queueTime;
        long requestEnd = requestCreate + TimeUnit.MILLISECONDS.toNanos(3L);
        long responseBegin = requestCreate + TimeUnit.MILLISECONDS.toNanos(5L);
        long responseComplete = requestCreate + TimeUnit.MILLISECONDS.toNanos(7L);
        long requestTotalTime = queueTime + (responseComplete - requestBegin);
        HttpClientLogger.RequestInfo requestInfo = HttpClientLogger.RequestInfo.from((Request)request, (long)requestTimestamp, (long)requestCreate, (long)requestBegin, (long)requestEnd);
        HttpClientLogger.ResponseInfo responseInfo = HttpClientLogger.ResponseInfo.from(Optional.of(response), (long)responseSize, (long)responseBegin, (long)responseComplete);
        logger.log(requestInfo, responseInfo);
        logger.close();
        String actual = com.google.common.io.Files.asCharSource((File)this.file, (Charset)StandardCharsets.UTF_8).read();
        String[] columns = actual.trim().split("\\t");
        Assert.assertEquals((String)columns[0], (String)ISO_FORMATTER.format(Instant.ofEpochMilli(requestTimestamp)));
        Assert.assertEquals((String)columns[1], (String)HttpVersion.HTTP_2.toString());
        Assert.assertEquals((String)columns[2], (String)method);
        Assert.assertEquals((String)columns[3], (String)uri.toString());
        Assert.assertEquals((String)columns[4], (String)Integer.toString(status));
        Assert.assertEquals((String)columns[5], (String)Long.toString(responseSize));
        Assert.assertEquals((String)columns[6], (String)Long.toString(TimeUnit.NANOSECONDS.toMillis(requestTotalTime)));
        Assert.assertEquals((String)columns[7], (String)Long.toString(TimeUnit.NANOSECONDS.toMillis(queueTime)));
        Assert.assertEquals((String)columns[8], (String)Long.toString(TimeUnit.NANOSECONDS.toMillis(requestEnd - requestBegin)));
        Assert.assertEquals((String)columns[9], (String)Long.toString(TimeUnit.NANOSECONDS.toMillis(responseBegin - requestEnd)));
        Assert.assertEquals((String)columns[10], (String)Long.toString(TimeUnit.NANOSECONDS.toMillis(responseComplete - responseBegin)));
        Assert.assertEquals((String)columns[11], (String)Long.toString(responseInfo.getResponseTimestampMillis() - requestTimestamp));
        Assert.assertEquals((String)columns[12], (String)"test-token");
    }

    @Test
    public void testClientLogNoResponse() throws Exception {
        String method = "GET";
        URI uri = new URI("http://www.google.com");
        long requestTimestamp = System.currentTimeMillis();
        HttpFields headers = new HttpFields();
        headers.add("X-Airlift-Tracetoken", "test-token");
        TestRequest request = new TestRequest(HttpVersion.HTTP_1_1, method, uri, headers);
        DefaultHttpClientLogger logger = new DefaultHttpClientLogger(this.file.getAbsolutePath(), 1, 256, new DataSize(1.0, DataSize.Unit.MEGABYTE), new Duration(10.0, TimeUnit.SECONDS), Long.MAX_VALUE, false);
        HttpClientLogger.RequestInfo requestInfo = HttpClientLogger.RequestInfo.from((Request)request, (long)requestTimestamp);
        HttpClientLogger.ResponseInfo responseInfo = HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(new TimeoutException("timeout")));
        logger.log(requestInfo, responseInfo);
        logger.close();
        String actual = com.google.common.io.Files.asCharSource((File)this.file, (Charset)StandardCharsets.UTF_8).read();
        String[] columns = actual.trim().split("\\t");
        Assert.assertEquals((String)columns[0], (String)ISO_FORMATTER.format(Instant.ofEpochMilli(requestTimestamp)));
        Assert.assertEquals((String)columns[1], (String)HttpVersion.HTTP_1_1.toString());
        Assert.assertEquals((String)columns[2], (String)method);
        Assert.assertEquals((String)columns[3], (String)uri.toString());
        Assert.assertEquals((String)columns[4], (String)((String)HttpRequestEvent.getFailureReason((HttpClientLogger.ResponseInfo)responseInfo).get()));
        Assert.assertEquals((String)columns[5], (String)Integer.toString(-1));
        Assert.assertNotEquals((Object)columns[6], (Object)Long.toString(0L));
        Assert.assertEquals((String)columns[7], (String)Long.toString(0L));
        Assert.assertEquals((String)columns[8], (String)Long.toString(0L));
        Assert.assertEquals((String)columns[9], (String)Long.toString(0L));
        Assert.assertEquals((String)columns[10], (String)Long.toString(0L));
        Assert.assertEquals((String)columns[11], (String)Long.toString(responseInfo.getResponseTimestampMillis() - requestTimestamp));
        Assert.assertEquals((String)columns[12], (String)"test-token");
    }

    @Test
    public void testClientLogPeriodicFlush() throws Exception {
        long now = System.currentTimeMillis();
        TestRequest request = new TestRequest(HttpVersion.HTTP_1_1, "GET", new URI("http://www.google.com"), new HttpFields());
        DefaultHttpClientLogger logger = new DefaultHttpClientLogger(this.file.getAbsolutePath(), 1, 256, new DataSize(1.0, DataSize.Unit.MEGABYTE), new Duration(1.0, TimeUnit.MILLISECONDS), Long.MAX_VALUE, false);
        HttpClientLogger.RequestInfo requestInfo = HttpClientLogger.RequestInfo.from((Request)request, (long)now);
        HttpClientLogger.ResponseInfo responseInfo = HttpClientLogger.ResponseInfo.from(Optional.empty(), (long)0L, (long)now, (long)now);
        logger.log(requestInfo, responseInfo);
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(20L);
            logger.log(requestInfo, responseInfo);
            List<String> lines = Files.readAllLines(this.file.toPath(), StandardCharsets.UTF_8);
            if (!lines.isEmpty()) break;
        }
        List<String> lines = Files.readAllLines(this.file.toPath(), StandardCharsets.UTF_8);
        Assertions.assertThat(lines).size().isGreaterThanOrEqualTo(1);
    }

    private class TestResponse
    implements Response {
        private final int status;

        TestResponse(int status) {
            this.status = status;
        }

        public Request getRequest() {
            return null;
        }

        public <T extends Response.ResponseListener> List<T> getListeners(Class<T> listenerClass) {
            return null;
        }

        public HttpVersion getVersion() {
            return null;
        }

        public int getStatus() {
            return this.status;
        }

        public String getReason() {
            return null;
        }

        public HttpFields getHeaders() {
            return null;
        }

        public boolean abort(Throwable cause) {
            throw new UnsupportedOperationException();
        }
    }

    private class TestRequest
    implements Request {
        private final HttpVersion protocolVersion;
        private final String method;
        private final URI uri;
        @Nullable
        private final HttpFields headers;

        TestRequest(HttpVersion protocolVersion, String method, URI uri, HttpFields headers) {
            this.protocolVersion = Objects.requireNonNull(protocolVersion, "protocolVersion is null");
            this.method = Objects.requireNonNull(method, "method is null");
            this.uri = Objects.requireNonNull(uri, "uri is null");
            this.headers = headers;
        }

        public String getScheme() {
            return null;
        }

        public Request scheme(String scheme) {
            throw new UnsupportedOperationException();
        }

        public String getHost() {
            return null;
        }

        public int getPort() {
            return 0;
        }

        public String getMethod() {
            return this.method;
        }

        public Request method(HttpMethod method) {
            throw new UnsupportedOperationException();
        }

        public Request method(String method) {
            throw new UnsupportedOperationException();
        }

        public String getPath() {
            return null;
        }

        public Request path(String path) {
            throw new UnsupportedOperationException();
        }

        public String getQuery() {
            return null;
        }

        public URI getURI() {
            return this.uri;
        }

        public HttpVersion getVersion() {
            return this.protocolVersion;
        }

        public Request version(HttpVersion version) {
            throw new UnsupportedOperationException();
        }

        public Fields getParams() {
            return null;
        }

        public Request param(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public HttpFields getHeaders() {
            return this.headers;
        }

        public Request header(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public Request header(HttpHeader header, String value) {
            throw new UnsupportedOperationException();
        }

        public List<HttpCookie> getCookies() {
            return null;
        }

        public Request cookie(HttpCookie cookie) {
            throw new UnsupportedOperationException();
        }

        public Request attribute(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> getAttributes() {
            return null;
        }

        public ContentProvider getContent() {
            return null;
        }

        public Request content(ContentProvider content) {
            throw new UnsupportedOperationException();
        }

        public Request content(ContentProvider content, String contentType) {
            throw new UnsupportedOperationException();
        }

        public Request file(Path file) {
            throw new UnsupportedOperationException();
        }

        public Request file(Path file, String contentType) {
            throw new UnsupportedOperationException();
        }

        public String getAgent() {
            return null;
        }

        public Request agent(String agent) {
            throw new UnsupportedOperationException();
        }

        public Request accept(String ... accepts) {
            throw new UnsupportedOperationException();
        }

        public long getIdleTimeout() {
            return 0L;
        }

        public Request idleTimeout(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public long getTimeout() {
            return 0L;
        }

        public Request timeout(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        public boolean isFollowRedirects() {
            return false;
        }

        public Request followRedirects(boolean follow) {
            throw new UnsupportedOperationException();
        }

        public <T extends Request.RequestListener> List<T> getRequestListeners(Class<T> listenerClass) {
            return null;
        }

        public Request listener(Request.Listener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onRequestQueued(Request.QueuedListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onRequestBegin(Request.BeginListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onRequestHeaders(Request.HeadersListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onRequestCommit(Request.CommitListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onRequestContent(Request.ContentListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onRequestSuccess(Request.SuccessListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onRequestFailure(Request.FailureListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onResponseBegin(Response.BeginListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onResponseHeader(Response.HeaderListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onResponseHeaders(Response.HeadersListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onResponseContent(Response.ContentListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onResponseContentAsync(Response.AsyncContentListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onResponseSuccess(Response.SuccessListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onResponseFailure(Response.FailureListener listener) {
            throw new UnsupportedOperationException();
        }

        public Request onComplete(Response.CompleteListener listener) {
            throw new UnsupportedOperationException();
        }

        public ContentResponse send() {
            throw new UnsupportedOperationException();
        }

        public void send(Response.CompleteListener listener) {
            throw new UnsupportedOperationException();
        }

        public boolean abort(Throwable cause) {
            throw new UnsupportedOperationException();
        }

        public Throwable getAbortCause() {
            return null;
        }
    }
}

