/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.jetty;

import com.facebook.airlift.http.client.AbstractHttpClientTest;
import com.facebook.airlift.http.client.HttpClientConfig;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.TestingRequestFilter;
import com.facebook.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.airlift.http.client.spnego.KerberosConfig;
import com.facebook.airlift.testing.Closeables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJettyHttpsClient
extends AbstractHttpClientTest {
    private JettyHttpClient httpClient;

    TestJettyHttpsClient() {
        super("localhost", Resources.getResource((String)"localhost.keystore").toString());
    }

    @BeforeClass
    public void setUpHttpClient() {
        this.httpClient = new JettyHttpClient("test-shared", this.createClientConfig(), this.createKerberosConfig(), (Iterable)ImmutableList.of((Object)new TestingRequestFilter()));
    }

    @AfterClass(alwaysRun=true)
    public void tearDownHttpClient() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.httpClient});
    }

    @Override
    protected HttpClientConfig createClientConfig() {
        return new HttpClientConfig().setHttp2Enabled(false).setKeyStorePath(Resources.getResource((String)"localhost.keystore").getPath()).setKeyStorePassword("changeit").setTrustStorePath(Resources.getResource((String)"localhost.truststore").getPath()).setTrustStorePassword("changeit");
    }

    protected KerberosConfig createKerberosConfig() {
        return new KerberosConfig();
    }

    @Override
    public <T, E extends Exception> T executeRequest(Request request, ResponseHandler<T, E> responseHandler) throws Exception {
        return (T)this.httpClient.execute(request, responseHandler);
    }

    @Override
    public <T, E extends Exception> T executeRequest(HttpClientConfig config, Request request, ResponseHandler<T, E> responseHandler) throws Exception {
        config.setKeyStorePath(Resources.getResource((String)"localhost.keystore").getPath()).setKeyStorePassword("changeit").setTrustStorePath(Resources.getResource((String)"localhost.truststore").getPath()).setTrustStorePassword("changeit");
        try (JettyHttpClient client = new JettyHttpClient("test-private", config, this.createKerberosConfig(), (Iterable)ImmutableList.of((Object)new TestingRequestFilter()));){
            Object object = client.execute(request, responseHandler);
            return (T)object;
        }
    }

    @Override
    @Test(invocationCount=10, successPercentage=50, timeOut=20000L)
    public void testConnectTimeout() throws Exception {
        super.testConnectTimeout();
    }

    @Test(expectedExceptions={IOException.class})
    public void testCertHostnameMismatch() throws Exception {
        URI uri = new URI("https", null, "127.0.0.1", this.baseURI.getPort(), "/", null, null);
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        this.executeRequest(request, new AbstractHttpClientTest.ExceptionResponseHandler());
    }

    @Override
    @Test(expectedExceptions={IOException.class, IllegalStateException.class})
    public void testConnectReadRequestClose() throws Exception {
        super.testConnectReadRequestClose();
    }

    @Override
    @Test(expectedExceptions={IOException.class, IllegalStateException.class})
    public void testConnectNoReadClose() throws Exception {
        super.testConnectNoReadClose();
    }

    @Override
    @Test(expectedExceptions={IOException.class, TimeoutException.class, IllegalStateException.class})
    public void testConnectReadIncompleteClose() throws Exception {
        super.testConnectReadIncompleteClose();
    }
}

