/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.jetty;

import com.facebook.airlift.http.client.jetty.BodyGeneratorContentProvider;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

abstract class AbstractContentProvider
implements Request.Content {
    protected final AtomicReference<Throwable> failed = new AtomicReference<Object>(null);
    protected final AtomicReference<Runnable> demand = new AtomicReference<Object>(null);
    private final SerializedInvoker invoker = new SerializedInvoker(BodyGeneratorContentProvider.class);
    private final AutoLock lock = new AutoLock();

    AbstractContentProvider() {
    }

    public void demand(Runnable runnable) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.demand.get() != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demand.set(runnable);
        }
        this.invoker.run(this::invokeDemandCallback);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock ignored = this.lock.lock();){
            demandCallback = this.demand.get();
            this.demand.set(null);
        }
        if (demandCallback != null) {
            ExceptionUtil.run((Runnable)demandCallback, this::fail);
        }
    }

    public void fail(Throwable throwable) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.failed.get() != null) {
                return;
            }
            this.failed.set(throwable);
        }
    }
}

