/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.jetty;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.jetty.AbstractContentProvider;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.Content;

class BodyGeneratorContentProvider
extends AbstractContentProvider {
    private static final ByteBuffer DONE = ByteBuffer.allocate(0);
    private static final ByteBuffer EXCEPTION = ByteBuffer.allocate(0);
    private final BodyGenerator bodyGenerator;
    private final Executor executor;
    private final Iterator<ByteBuffer> iterator;

    public BodyGeneratorContentProvider(BodyGenerator bodyGenerator, Executor executor) {
        this.bodyGenerator = bodyGenerator;
        this.executor = executor;
        this.iterator = this.iterator();
    }

    public Content.Chunk read() {
        if (this.failed.get() != null) {
            return Content.Chunk.from((Throwable)((Throwable)this.failed.get()));
        }
        return this.iterator.hasNext() ? Content.Chunk.from((ByteBuffer)this.iterator.next(), (!this.iterator.hasNext() ? 1 : 0) != 0) : Content.Chunk.EOF;
    }

    @Override
    public void fail(Throwable throwable) {
        super.fail(throwable);
        this.iterator.forEachRemaining(chunk -> {});
    }

    public Iterator<ByteBuffer> iterator() {
        final ArrayBlockingQueue chunks = new ArrayBlockingQueue(16);
        final AtomicReference exception = new AtomicReference();
        this.executor.execute(() -> {
            try (BodyGeneratorOutputStream out = new BodyGeneratorOutputStream(chunks);){
                this.bodyGenerator.write(out);
            }
            catch (Exception e) {
                exception.set(e);
                chunks.add(EXCEPTION);
            }
        });
        return new AbstractIterator<ByteBuffer>(){

            protected ByteBuffer computeNext() {
                ByteBuffer chunk;
                try {
                    chunk = (ByteBuffer)chunks.take();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted", e);
                }
                if (chunk == EXCEPTION) {
                    Throwables.throwIfUnchecked((Throwable)((Throwable)exception.get()));
                    throw new RuntimeException((Throwable)exception.get());
                }
                if (chunk == DONE) {
                    return (ByteBuffer)this.endOfData();
                }
                return chunk;
            }
        };
    }

    private static final class BodyGeneratorOutputStream
    extends OutputStream {
        private final BlockingQueue<ByteBuffer> chunks;

        private BodyGeneratorOutputStream(BlockingQueue<ByteBuffer> chunks) {
            this.chunks = chunks;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.chunks.put(ByteBuffer.wrap(new byte[]{(byte)b}));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                byte[] copy = Arrays.copyOfRange(b, off, len);
                this.chunks.put(ByteBuffer.wrap(copy));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.chunks.put(DONE);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
    }
}

