/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.jetty;

import ch.qos.logback.core.AsyncAppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.FileSize;
import com.facebook.airlift.http.client.jetty.HttpClientLogLayout;
import com.facebook.airlift.http.client.jetty.HttpClientLogger;
import com.facebook.airlift.http.client.jetty.HttpRequestEvent;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.units.DataSize;
import com.facebook.airlift.units.Duration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class DefaultHttpClientLogger
implements HttpClientLogger {
    private static final Logger LOG = Logger.get(DefaultHttpClientLogger.class);
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final String LOG_FILE_EXTENSION = ".log";
    private final AsyncAppenderBase<HttpRequestEvent> asyncAppender;

    DefaultHttpClientLogger(String filename, int maxHistory, int queueSize, DataSize bufferSize, Duration flushInterval, long maxFileSizeInBytes, boolean compressionEnabled) {
        ContextBase context = new ContextBase();
        HttpClientLogLayout httpLogLayout = new HttpClientLogLayout();
        DefaultHttpClientLogger.recoverTempFiles(filename);
        FlushingFileAppender fileAppender = new FlushingFileAppender(flushInterval);
        SizeAndTimeBasedFNATP triggeringPolicy = new SizeAndTimeBasedFNATP();
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        rollingPolicy.setContext((Context)context);
        rollingPolicy.setMaxHistory(maxHistory);
        rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)triggeringPolicy);
        rollingPolicy.setParent(fileAppender);
        rollingPolicy.setFileNamePattern(filename + "-%d{yyyy-MM-dd}.%i.log");
        if (compressionEnabled) {
            rollingPolicy.setFileNamePattern(rollingPolicy.getFileNamePattern() + ".gz");
        }
        triggeringPolicy.setContext((Context)context);
        triggeringPolicy.setTimeBasedRollingPolicy(rollingPolicy);
        triggeringPolicy.setMaxFileSize(new FileSize(maxFileSizeInBytes));
        fileAppender.setContext((Context)context);
        fileAppender.setFile(filename);
        fileAppender.setAppend(true);
        fileAppender.setBufferSize(new FileSize(bufferSize.toBytes()));
        fileAppender.setLayout((Layout)httpLogLayout);
        fileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        fileAppender.setImmediateFlush(false);
        this.asyncAppender = new AsyncAppenderBase();
        this.asyncAppender.setContext((Context)context);
        this.asyncAppender.setQueueSize(queueSize);
        this.asyncAppender.addAppender(fileAppender);
        rollingPolicy.start();
        triggeringPolicy.start();
        fileAppender.start();
        this.asyncAppender.start();
    }

    @Override
    public void log(HttpClientLogger.RequestInfo requestInfo, HttpClientLogger.ResponseInfo responseInfo) {
        this.asyncAppender.doAppend((Object)HttpRequestEvent.createHttpRequestEvent(requestInfo, responseInfo));
    }

    @Override
    public void close() {
        this.asyncAppender.stop();
    }

    @Override
    public int getQueueSize() {
        return this.asyncAppender.getNumberOfElementsInQueue();
    }

    private static void recoverTempFiles(String logPath) {
        File logPathFile = Path.of(logPath, new String[0]).getParent().toFile();
        File[] tempFiles = logPathFile.listFiles((directory, name) -> name.endsWith(TEMP_FILE_EXTENSION));
        if (tempFiles != null) {
            for (File tempFile : tempFiles) {
                String newName = tempFile.getName().substring(0, tempFile.getName().length() - TEMP_FILE_EXTENSION.length());
                File newFile = Path.of(tempFile.getParent(), newName + LOG_FILE_EXTENSION).toFile();
                if (tempFile.renameTo(newFile)) {
                    LOG.info("Recovered temp file: %s", new Object[]{tempFile});
                    continue;
                }
                LOG.warn("Could not rename temp file [%s] to [%s]", new Object[]{tempFile, newFile});
            }
        }
    }

    private static class FlushingFileAppender<T>
    extends RollingFileAppender<T> {
        private final AtomicLong lastFlushed = new AtomicLong(System.nanoTime());
        private final long flushIntervalNanos;

        private FlushingFileAppender(Duration flushInterval) {
            this.flushIntervalNanos = flushInterval.roundTo(TimeUnit.NANOSECONDS);
        }

        protected void subAppend(T event) {
            super.subAppend(event);
            long now = System.nanoTime();
            long last = this.lastFlushed.get();
            if (now - last > this.flushIntervalNanos && this.lastFlushed.compareAndSet(last, now)) {
                this.flush();
            }
        }

        private void flush() {
            try {
                this.streamWriteLock.lock();
                try {
                    this.getOutputStream().flush();
                }
                finally {
                    this.streamWriteLock.unlock();
                }
            }
            catch (IOException e) {
                this.started = false;
                this.addStatus((Status)new ErrorStatus("IO failure in appender", (Object)this, (Throwable)e));
            }
        }
    }
}

