/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.spnego;

import com.facebook.airlift.http.client.spnego.ForwardingResponseListener;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.WWWAuthenticationProtocolHandler;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;

public class SpnegoAuthenticationProtocolHandler
extends WWWAuthenticationProtocolHandler {
    private static final String NEGOTIATE = HttpHeader.NEGOTIATE.asString();

    public SpnegoAuthenticationProtocolHandler(HttpClient client) {
        super(client);
    }

    public String getName() {
        return "spnego";
    }

    public Response.Listener getResponseListener() {
        return new ForwardingResponseListener(super.getResponseListener()){

            @Override
            public void onComplete(Result result) {
                final HttpHeader header = SpnegoAuthenticationProtocolHandler.this.getAuthenticateHeader();
                final Response response = result.getResponse();
                super.onComplete(new Result(result.getRequest(), result.getRequestFailure(), new Response(){

                    public Request getRequest() {
                        return response.getRequest();
                    }

                    public HttpVersion getVersion() {
                        return response.getVersion();
                    }

                    public int getStatus() {
                        return response.getStatus();
                    }

                    public String getReason() {
                        return response.getReason();
                    }

                    public HttpFields getHeaders() {
                        return HttpFields.build((HttpFields)response.getHeaders(), (HttpField)new HttpField(header, NEGOTIATE + " realm=\"dummy\""));
                    }

                    public HttpFields getTrailers() {
                        return response.getTrailers();
                    }

                    public CompletableFuture<Boolean> abort(Throwable cause) {
                        return response.abort(cause);
                    }
                }, result.getResponseFailure()));
            }
        };
    }
}

