/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.thrift;

import com.facebook.airlift.http.client.HeaderName;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.ResponseHandlerUtils;
import com.facebook.airlift.http.client.thrift.ThriftProtocolUtils;
import com.facebook.airlift.http.client.thrift.ThriftRequestUtils;
import com.facebook.airlift.http.client.thrift.ThriftResponse;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.google.common.collect.ListMultimap;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.eclipse.jetty.http.HttpStatus;

public class ThriftResponseHandler<T>
implements ResponseHandler<ThriftResponse<T>, RuntimeException> {
    private final ThriftCodec<T> thriftCodec;

    public ThriftResponseHandler(ThriftCodec<T> thriftCodec) {
        this.thriftCodec = Objects.requireNonNull(thriftCodec, "thriftCodec is null");
    }

    @Override
    public ThriftResponse<T> handleException(Request request, Exception exception) {
        throw ResponseHandlerUtils.propagate(request, exception);
    }

    @Override
    public ThriftResponse<T> handle(Request request, Response response) {
        if (!HttpStatus.isSuccess((int)response.getStatusCode())) {
            return this.createErrorResponse(response);
        }
        Object value = null;
        IllegalArgumentException exception = null;
        try {
            Protocol protocol = this.getThriftProtocol(response.getHeaders());
            value = ThriftProtocolUtils.read(this.thriftCodec, protocol, response.getInputStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            exception = new IllegalArgumentException("Unable to create " + String.valueOf(this.thriftCodec.getType()) + " from THRIFT response", e);
        }
        return new ThriftResponse<Object>(response.getStatusCode(), null, response.getHeaders(), value, exception);
    }

    private ThriftResponse<T> createErrorResponse(final Response response) {
        ByteSource byteSource = new ByteSource(){

            public InputStream openStream() throws IOException {
                return response.getInputStream();
            }
        };
        try {
            String errorMessage = byteSource.asCharSource(StandardCharsets.UTF_8).read();
            return new ThriftResponse<Object>(response.getStatusCode(), errorMessage, response.getHeaders(), null, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Protocol getThriftProtocol(ListMultimap<HeaderName, String> headers) {
        HeaderName contentTypeHeader = HeaderName.of("Content-Type");
        if (!headers.containsKey((Object)contentTypeHeader) || headers.get((Object)contentTypeHeader).size() != 1) {
            throw new IllegalArgumentException("Invalid response. Unable to create " + String.valueOf(this.thriftCodec.getType()) + " from THRIFT response");
        }
        MediaType mediaType = MediaType.parse((String)((String)headers.get((Object)contentTypeHeader).get(0)));
        String mimeType = mediaType.toString().toLowerCase();
        if (!ThriftRequestUtils.validThriftMimeTypes.contains(mimeType)) {
            throw new IllegalArgumentException("Invalid response. Unable to create " + String.valueOf(this.thriftCodec.getType()) + " from THRIFT response");
        }
        String encodingType = mimeType.substring("application/x-thrift+".length());
        return Protocol.valueOf((String)encodingType.toUpperCase());
    }
}

