/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.jetty;

import com.facebook.airlift.http.client.jetty.AbstractContentProvider;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.jetty.io.Content;

public class ChunkedBytesContentProvider
extends AbstractContentProvider {
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final byte[] bytes;
    private final int bufferSize;
    private ChunkedIterator iterator;
    String contentType;

    public ChunkedBytesContentProvider(byte[] bytes) {
        this(APPLICATION_OCTET_STREAM, bytes, 4096);
    }

    public ChunkedBytesContentProvider(byte[] bytes, int bufferSizeInBytes) {
        this(APPLICATION_OCTET_STREAM, bytes, bufferSizeInBytes);
    }

    public ChunkedBytesContentProvider(String contentType, byte[] bytes) {
        this(contentType, bytes, 4096);
    }

    public ChunkedBytesContentProvider(String contentType, byte[] bytes, int bufferSizeInBytes) {
        this.bytes = Objects.requireNonNull(bytes, "bytes is null");
        Preconditions.checkArgument((bufferSizeInBytes > 0 ? 1 : 0) != 0, (String)"bufferSizeInBytes must be greater than zero: %s", (int)bufferSizeInBytes);
        this.bufferSize = bufferSizeInBytes;
        this.iterator = new ChunkedIterator(bytes, this.bufferSize);
        this.contentType = Objects.requireNonNull(contentType, "contentType is null");
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getLength() {
        return this.bytes.length;
    }

    public Content.Chunk read() {
        if (this.iterator.hasNext()) {
            ByteBuffer buf = this.iterator.next();
            boolean hasNext = this.iterator.hasNext();
            return Content.Chunk.from((ByteBuffer)buf, (!hasNext ? 1 : 0) != 0);
        }
        return null;
    }

    @Override
    public void fail(Throwable throwable) {
        super.fail(throwable);
        this.iterator.forEachRemaining(chunk -> {});
    }

    public boolean rewind() {
        this.iterator = new ChunkedIterator(this.bytes, this.bufferSize);
        return true;
    }

    private static class ChunkedIterator
    implements Iterator<ByteBuffer> {
        private final ByteBuffer buffer;
        private final int bufferSize;
        private int index;

        private ChunkedIterator(byte[] bytes, int bufferSize) {
            this.buffer = ByteBuffer.wrap(bytes);
            this.bufferSize = bufferSize;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.buffer.capacity();
        }

        @Override
        public ByteBuffer next() {
            if (this.index == this.buffer.capacity()) {
                throw new NoSuchElementException();
            }
            int length = Math.min(this.buffer.capacity() - this.index, this.bufferSize);
            this.buffer.position(this.index);
            this.buffer.limit(this.index + length);
            this.index += length;
            return this.buffer;
        }
    }
}

