/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.client.thrift;

import com.facebook.airlift.http.client.HeaderName;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import jakarta.annotation.Nullable;
import java.util.List;

public class ThriftResponse<T> {
    private final int statusCode;
    private final String errorMessage;
    private final ListMultimap<HeaderName, String> headers;
    private final T value;
    private final IllegalArgumentException exception;

    ThriftResponse(int statusCode, String errorMessage, ListMultimap<HeaderName, String> headers, T value, IllegalArgumentException exception) {
        this.statusCode = statusCode;
        this.errorMessage = errorMessage;
        this.headers = headers != null ? ImmutableListMultimap.copyOf(headers) : null;
        this.value = value;
        this.exception = exception;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public T getValue() {
        return this.value;
    }

    @Nullable
    public String getHeader(String name) {
        List values = this.getHeaders().get((Object)HeaderName.of(name));
        return values.isEmpty() ? null : (String)values.get(0);
    }

    public List<String> getHeaders(String name) {
        return this.headers.get((Object)HeaderName.of(name));
    }

    public ListMultimap<HeaderName, String> getHeaders() {
        return this.headers;
    }

    public IllegalArgumentException getException() {
        return this.exception;
    }
}

