/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import java.util.Objects;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.weakref.jmx.Managed;

public class ConnectionStats {
    private final ConnectionStatistics connectionStats;

    public ConnectionStats(ConnectionStatistics connectionStats) {
        this.connectionStats = Objects.requireNonNull(connectionStats, "connectionStats is null");
    }

    @Managed(description="total number of bytes received by all connections")
    public long getReceivedBytes() {
        return this.connectionStats.getReceivedBytes();
    }

    @Managed(description="total number of bytes sent by all connections")
    public long getSentBytes() {
        return this.connectionStats.getSentBytes();
    }

    @Managed(description="max connection duration (ms)")
    public long getMaxConnectionDuration() {
        return this.connectionStats.getConnectionDurationMax();
    }

    @Managed(description="mean connection duration (ms)")
    public double getMeanConnectionDuration() {
        return this.connectionStats.getConnectionDurationMean();
    }

    @Managed(description="standard deviation of connection duration")
    public double getConnectionDurationStdDev() {
        return this.connectionStats.getConnectionDurationStdDev();
    }

    @Managed(description="total number of connections opened")
    public long getTotalConnectionCount() {
        return this.connectionStats.getConnectionsTotal();
    }

    @Managed(description="number of open connections")
    public long getOpenConnectionCount() {
        return this.connectionStats.getConnections();
    }

    @Managed(description="max number of open connections")
    public long getMaxOpenConnections() {
        return this.connectionStats.getConnectionsMax();
    }

    @Managed(description="total number of messages received")
    public long getReceivedMessageCount() {
        return this.connectionStats.getReceivedMessages();
    }

    @Managed(description="total number of messages sent")
    public long getSentMessageCount() {
        return this.connectionStats.getSentMessages();
    }
}

