/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.facebook.airlift.http.server.AuthenticationException;
import com.facebook.airlift.http.server.Authenticator;
import com.facebook.airlift.http.server.KerberosConfig;
import com.facebook.airlift.log.Logger;
import com.sun.security.auth.module.Krb5LoginModule;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosAuthenticator
implements Authenticator {
    private static final Logger LOG = Logger.get(KerberosAuthenticator.class);
    private static final String NEGOTIATE_SCHEME = "Negotiate";
    private final GSSManager gssManager = GSSManager.getInstance();
    private final LoginContext loginContext;
    private final GSSCredential serverCredential;

    @Inject
    public KerberosAuthenticator(final KerberosConfig config) {
        System.setProperty("java.security.krb5.conf", config.getKerberosConfig().getAbsolutePath());
        try {
            String hostname = Optional.ofNullable(config.getPrincipalHostname()).orElseGet(() -> KerberosAuthenticator.getLocalHost().getCanonicalHostName()).toLowerCase(Locale.US);
            final String servicePrincipal = config.getServiceName() + "/" + hostname;
            this.loginContext = new LoginContext("", null, null, new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("refreshKrb5Config", "true");
                    options.put("doNotPrompt", "true");
                    if (LOG.isDebugEnabled()) {
                        options.put("debug", "true");
                    }
                    if (config.getKeytab() != null) {
                        options.put("keyTab", config.getKeytab().getAbsolutePath());
                    }
                    options.put("isInitiator", "false");
                    options.put("useKeyTab", "true");
                    options.put("principal", servicePrincipal);
                    options.put("storeKey", "true");
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
                }
            });
            this.loginContext.login();
            this.serverCredential = KerberosAuthenticator.doAs(this.loginContext.getSubject(), () -> this.gssManager.createCredential(this.gssManager.createName(config.getServiceName() + "@" + hostname, GSSName.NT_HOSTBASED_SERVICE), Integer.MAX_VALUE, new Oid[]{new Oid("1.2.840.113554.1.2.2"), new Oid("1.3.6.1.5.5.2")}, 2));
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public void shutdown() {
        try {
            this.loginContext.logout();
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Principal authenticate(HttpServletRequest request) throws AuthenticationException {
        String[] parts;
        String header = request.getHeader("Authorization");
        String requestSpnegoToken = null;
        if (header != null && (parts = header.split("\\s+")).length == 2 && parts[0].equals(NEGOTIATE_SCHEME)) {
            try {
                requestSpnegoToken = parts[1];
                Optional<Principal> principal = this.authenticate(parts[1]);
                if (principal.isPresent()) {
                    return principal.get();
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Authentication error for token: " + parts[1], e);
            }
        }
        if (requestSpnegoToken != null) {
            throw new AuthenticationException("Authentication failed for token: " + requestSpnegoToken, NEGOTIATE_SCHEME);
        }
        throw new AuthenticationException(null, NEGOTIATE_SCHEME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Principal> authenticate(String token) {
        GSSContext context = KerberosAuthenticator.doAs(this.loginContext.getSubject(), () -> this.gssManager.createContext(this.serverCredential));
        try {
            byte[] inputToken = Base64.getDecoder().decode(token);
            context.acceptSecContext(inputToken, 0, inputToken.length);
            if (context.isEstablished()) {
                Optional<Principal> optional = Optional.of(new KerberosPrincipal(context.getSrcName().toString()));
                return optional;
            }
            LOG.debug("Failed to establish GSS context for token %s", new Object[]{token});
        }
        catch (GSSException e) {
            LOG.debug((Throwable)e, "Authentication failed for token %s", new Object[]{token});
        }
        finally {
            try {
                context.dispose();
            }
            catch (GSSException gSSException) {}
        }
        return Optional.empty();
    }

    private static <T> T doAs(Subject subject, GssSupplier<T> action) {
        return (T)Subject.doAs(subject, () -> {
            try {
                return action.get();
            }
            catch (GSSException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface GssSupplier<T> {
        public T get() throws GSSException;
    }
}

