/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.facebook.airlift.http.server.HttpServerConfig;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.util.resource.PathResourceFactory;

public class HashLoginServiceProvider
implements Provider<HashLoginService> {
    private final HttpServerConfig config;
    private final PathResourceFactory pathResourceFactory = new PathResourceFactory();

    @Inject
    public HashLoginServiceProvider(HttpServerConfig config) {
        this.config = config;
    }

    public HashLoginService get() {
        String authConfig = this.config.getUserAuthFile();
        if (!Strings.isNullOrEmpty((String)authConfig)) {
            return new HashLoginService("Airlift", this.pathResourceFactory.newResource(authConfig));
        }
        return null;
    }
}

