/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.facebook.airlift.event.client.EventClient;
import com.facebook.airlift.http.server.AuthorizationEnabledServlet;
import com.facebook.airlift.http.server.Authorizer;
import com.facebook.airlift.http.server.ClassPathResourceHandler;
import com.facebook.airlift.http.server.ConnectionStats;
import com.facebook.airlift.http.server.DelimitedRequestLog;
import com.facebook.airlift.http.server.HttpServerBinder;
import com.facebook.airlift.http.server.HttpServerChannelListener;
import com.facebook.airlift.http.server.HttpServerConfig;
import com.facebook.airlift.http.server.HttpServerInfo;
import com.facebook.airlift.http.server.RequestStats;
import com.facebook.airlift.http.server.StatsRecordingHandler;
import com.facebook.airlift.http.server.TimingFilter;
import com.facebook.airlift.http.server.TraceTokenFilter;
import com.facebook.airlift.http.utils.jetty.ConcurrentScheduler;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.airlift.security.pem.PemReader;
import com.facebook.airlift.tracetoken.TraceTokenManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ServerSocketChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServer;
import org.eclipse.jetty.ee10.servlet.ErrorHandler;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HttpServer {
    private final Server server;
    private final boolean registerErrorHandler;
    private final DelimitedRequestLog requestLog;
    private ConnectionStats httpConnectionStats;
    private ConnectionStats httpsConnectionStats;
    private final Optional<ZonedDateTime> certificateExpiration;

    public HttpServer(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Servlet defaultServlet, Map<String, Servlet> servlets, Map<String, String> parameters, Set<Filter> filters, Set<HttpServerBinder.HttpResourceBinding> resources, Servlet theAdminServlet, Map<String, String> adminParameters, Set<Filter> adminFilters, MBeanServer mbeanServer, LoginService loginService, TraceTokenManager tokenManager, RequestStats stats, EventClient eventClient, Authorizer authorizer) throws IOException {
        Objects.requireNonNull(httpServerInfo, "httpServerInfo is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(defaultServlet, "defaultServlet is null");
        Objects.requireNonNull(servlets, "servlets is null");
        QueuedThreadPool threadPool = new QueuedThreadPool(config.getMaxThreads());
        threadPool.setMinThreads(config.getMinThreads());
        threadPool.setIdleTimeout(Math.toIntExact(config.getThreadMaxIdleTime().toMillis()));
        threadPool.setName("http-worker");
        threadPool.setDetailedDump(true);
        this.server = new Server((ThreadPool)threadPool);
        this.server.setErrorHandler((Request.Handler)new ErrorHandler());
        this.registerErrorHandler = config.isShowStackTrace();
        if (mbeanServer != null) {
            MBeanContainer mbeanContainer = new MBeanContainer(mbeanServer);
            this.server.addBean((Object)mbeanContainer);
        }
        HttpConfiguration baseHttpConfiguration = new HttpConfiguration();
        baseHttpConfiguration.setSendServerVersion(false);
        baseHttpConfiguration.setSendXPoweredBy(false);
        baseHttpConfiguration.setUriCompliance(config.getUriComplianceMode().getUriCompliance());
        if (config.getMaxRequestHeaderSize() != null) {
            baseHttpConfiguration.setRequestHeaderSize(Math.toIntExact(config.getMaxRequestHeaderSize().toBytes()));
        }
        if (config.getMaxResponseHeaderSize() != null) {
            baseHttpConfiguration.setResponseHeaderSize(Math.toIntExact(config.getMaxResponseHeaderSize().toBytes()));
        }
        baseHttpConfiguration.setNotifyRemoteAsyncErrors(false);
        Object channelListener = null;
        this.requestLog = config.isLogEnabled() ? HttpServer.createDelimitedRequestLog(config, tokenManager, eventClient) : null;
        Scheduler concurrentScheduler = ConcurrentScheduler.createConcurrentScheduler((String)"http-server-timeout", (int)config.getTimeoutConcurrency(), (int)config.getTimeoutThreads());
        if (config.isHttpEnabled()) {
            HttpConfiguration httpConfiguration = new HttpConfiguration(baseHttpConfiguration);
            if (config.isHttpsEnabled()) {
                httpConfiguration.setSecureScheme("https");
                httpConfiguration.setSecurePort(httpServerInfo.getHttpsUri().getPort());
            }
            Integer acceptors = config.getHttpAcceptorThreads();
            Integer selectors = config.getHttpSelectorThreads();
            HttpConnectionFactory http1 = new HttpConnectionFactory(httpConfiguration);
            HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(httpConfiguration);
            http2c.setInitialSessionRecvWindow(Math.toIntExact(config.getHttp2InitialSessionReceiveWindowSize().toBytes()));
            http2c.setInitialStreamRecvWindow(Math.toIntExact(config.getHttp2InitialStreamReceiveWindowSize().toBytes()));
            http2c.setMaxConcurrentStreams(config.getHttp2MaxConcurrentStreams());
            http2c.setInputBufferSize(Math.toIntExact(config.getHttp2InputBufferSize().toBytes()));
            http2c.setStreamIdleTimeout(config.getHttp2StreamIdleTimeout().toMillis());
            ServerConnector httpConnector = HttpServer.createServerConnector(httpServerInfo.getHttpChannel(), this.server, null, concurrentScheduler, Objects.requireNonNullElse(acceptors, -1), Objects.requireNonNullElse(selectors, -1), new ConnectionFactory[]{http1, http2c});
            httpConnector.setName("http");
            httpConnector.setPort(httpServerInfo.getHttpUri().getPort());
            httpConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            httpConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            httpConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            ConnectionStatistics connectionStats = new ConnectionStatistics();
            httpConnector.addBean((Object)connectionStats);
            this.httpConnectionStats = new ConnectionStats(connectionStats);
            if (channelListener != null) {
                httpConnector.addBean(channelListener);
            }
            this.server.addConnector((Connector)httpConnector);
        }
        List<String> includedCipherSuites = config.getHttpsIncludedCipherSuites();
        List<String> excludedCipherSuites = config.getHttpsExcludedCipherSuites();
        if (config.isHttpsEnabled()) {
            HttpConfiguration httpsConfiguration = new HttpConfiguration(baseHttpConfiguration);
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(config.isSniHostCheck()));
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            Optional<KeyStore> pemKeyStore = HttpServer.tryLoadPemKeyStore(config);
            if (pemKeyStore.isPresent()) {
                sslContextFactory.setKeyStore(pemKeyStore.orElseThrow());
                sslContextFactory.setKeyStorePassword("");
            } else {
                sslContextFactory.setKeyStorePath(config.getKeystorePath());
                sslContextFactory.setKeyStorePassword(config.getKeystorePassword());
                if (config.getKeyManagerPassword() != null) {
                    sslContextFactory.setKeyManagerPassword(config.getKeyManagerPassword());
                }
            }
            if (config.getTrustStorePath() != null) {
                Optional<KeyStore> pemTrustStore = HttpServer.tryLoadPemTrustStore(config);
                if (pemTrustStore.isPresent()) {
                    sslContextFactory.setTrustStore(pemTrustStore.orElseThrow());
                    sslContextFactory.setTrustStorePassword("");
                } else {
                    sslContextFactory.setTrustStorePath(config.getTrustStorePath());
                    sslContextFactory.setTrustStorePassword(config.getTrustStorePassword());
                }
            }
            sslContextFactory.setIncludeCipherSuites(includedCipherSuites.toArray(new String[0]));
            sslContextFactory.setExcludeCipherSuites(excludedCipherSuites.toArray(new String[0]));
            sslContextFactory.setSecureRandomAlgorithm(config.getSecureRandomAlgorithm());
            sslContextFactory.setWantClientAuth(true);
            sslContextFactory.setSslSessionTimeout((int)config.getSslSessionTimeout().getValue(TimeUnit.SECONDS));
            sslContextFactory.setSslSessionCacheSize(config.getSslSessionCacheSize());
            sslContextFactory.setRenegotiationAllowed(false);
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, "http/1.1");
            Integer acceptors = config.getHttpsAcceptorThreads();
            Integer selectors = config.getHttpsSelectorThreads();
            ServerConnector httpsConnector = HttpServer.createServerConnector(httpServerInfo.getHttpsChannel(), this.server, null, concurrentScheduler, Objects.requireNonNullElse(acceptors, -1), Objects.requireNonNullElse(selectors, -1), new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory(httpsConfiguration)});
            httpsConnector.setName("https");
            httpsConnector.setPort(httpServerInfo.getHttpsUri().getPort());
            httpsConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            httpsConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            httpsConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            ConnectionStatistics connectionStats = new ConnectionStatistics();
            httpsConnector.addBean((Object)connectionStats);
            this.httpsConnectionStats = new ConnectionStats(connectionStats);
            if (channelListener != null) {
                httpsConnector.addBean(channelListener);
            }
            this.server.addConnector((Connector)httpsConnector);
        }
        if (theAdminServlet != null && config.isAdminEnabled()) {
            ServerConnector adminConnector;
            HttpConfiguration adminConfiguration = new HttpConfiguration(baseHttpConfiguration);
            QueuedThreadPool adminThreadPool = new QueuedThreadPool(config.getAdminMaxThreads());
            adminThreadPool.setName("http-admin-worker");
            adminThreadPool.setMinThreads(config.getAdminMinThreads());
            adminThreadPool.setIdleTimeout(Math.toIntExact(config.getThreadMaxIdleTime().toMillis()));
            if (config.isHttpsEnabled()) {
                adminConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                sslContextFactory.setKeyStorePath(config.getKeystorePath());
                sslContextFactory.setKeyStorePassword(config.getKeystorePassword());
                if (config.getKeyManagerPassword() != null) {
                    sslContextFactory.setKeyManagerPassword(config.getKeyManagerPassword());
                }
                sslContextFactory.setSecureRandomAlgorithm(config.getSecureRandomAlgorithm());
                sslContextFactory.setWantClientAuth(true);
                sslContextFactory.setIncludeCipherSuites(includedCipherSuites.toArray(new String[0]));
                sslContextFactory.setExcludeCipherSuites(excludedCipherSuites.toArray(new String[0]));
                SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, "http/1.1");
                adminConnector = HttpServer.createServerConnector(httpServerInfo.getAdminChannel(), this.server, (Executor)adminThreadPool, concurrentScheduler, 0, -1, new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory(adminConfiguration)});
            } else {
                HttpConnectionFactory http1 = new HttpConnectionFactory(adminConfiguration);
                HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(adminConfiguration);
                http2c.setMaxConcurrentStreams(config.getHttp2MaxConcurrentStreams());
                adminConnector = HttpServer.createServerConnector(httpServerInfo.getAdminChannel(), this.server, (Executor)adminThreadPool, concurrentScheduler, -1, -1, new ConnectionFactory[]{http1, http2c});
            }
            adminConnector.setName("admin");
            adminConnector.setPort(httpServerInfo.getAdminUri().getPort());
            adminConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            adminConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            adminConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            this.server.addConnector((Connector)adminConnector);
        }
        Handler.Sequence handlers = new Handler.Sequence(new Handler[0]);
        for (HttpServerBinder.HttpResourceBinding resource : resources) {
            GzipHandler gzipHandler = new GzipHandler((Handler)new ClassPathResourceHandler(resource.getBaseUri(), resource.getClassPathResourceBase(), resource.getWelcomeFiles(), resource.getExtraHeaders()));
            handlers.addHandler((Handler)gzipHandler);
        }
        handlers.addHandler((Handler)HttpServer.createServletContext(config, defaultServlet, servlets, parameters, filters, tokenManager, loginService, authorizer, "http", "https"));
        if (config.isRequestStatsEnabled()) {
            this.server.setRequestLog((RequestLog)new StatsRecordingHandler(stats));
        }
        StatisticsHandler statsHandler = new StatisticsHandler((Handler)handlers);
        ContextHandlerCollection rootHandlers = new ContextHandlerCollection(new ContextHandler[0]);
        if (theAdminServlet != null && config.isAdminEnabled()) {
            rootHandlers.addHandler((Handler)HttpServer.createServletContext(config, theAdminServlet, (Map<String, Servlet>)ImmutableMap.of(), adminParameters, adminFilters, tokenManager, loginService, authorizer, "admin"));
        }
        if (this.requestLog != null) {
            rootHandlers.addHandler((Handler)new HttpServerChannelListener(this.requestLog, (Handler)statsHandler));
        } else {
            rootHandlers.addHandler((Handler)statsHandler);
        }
        this.server.setHandler((Handler)rootHandlers);
        this.certificateExpiration = HttpServer.loadAllX509Certificates(config).stream().map(X509Certificate::getNotAfter).min(Comparator.naturalOrder()).map(date -> ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
    }

    private static ServletContextHandler createServletContext(HttpServerConfig config, Servlet defaultServlet, Map<String, Servlet> servlets, Map<String, String> parameters, Set<Filter> filters, TraceTokenManager tokenManager, LoginService loginService, Authorizer authorizer, String ... connectorNames) {
        ServletContextHandler context = new ServletContextHandler(0);
        context.addFilter(new FilterHolder((Filter)new TimingFilter()), "/*", null);
        if (tokenManager != null) {
            context.addFilter(new FilterHolder((Filter)new TraceTokenFilter(tokenManager)), "/*", null);
        }
        if (loginService != null) {
            SecurityHandler securityHandler = HttpServer.createSecurityHandler(loginService);
            context.setSecurityHandler(securityHandler);
        }
        for (Filter filter : filters) {
            context.addFilter(new FilterHolder(filter), "/*", null);
        }
        context.insertHandler((Handler.Singleton)new GzipHandler());
        ServletHolder servletHolder = new ServletHolder(defaultServlet);
        servletHolder.setInitParameters((Map)ImmutableMap.copyOf(parameters));
        context.addServlet(servletHolder, "/*");
        for (Map.Entry<String, Servlet> entry : servlets.entrySet()) {
            if (config.isAuthorizationEnabled()) {
                Preconditions.checkArgument((authorizer != null ? 1 : 0) != 0, (Object)"when authorization is enabled, authorizer implementation must be provided");
                AuthorizationEnabledServlet authorizationEnabledServlet = new AuthorizationEnabledServlet(entry.getValue(), authorizer, config.getDefaultAuthorizationPolicy(), config.getDefaultAllowedRoles(), config.isAllowUnsecureRequestsInAuthorizer());
                ServletHolder holder = new ServletHolder((Servlet)authorizationEnabledServlet);
                holder.setInitParameters((Map)ImmutableMap.copyOf(parameters));
                context.addServlet(holder, entry.getKey());
                continue;
            }
            ServletHolder holder = new ServletHolder(entry.getValue());
            holder.setInitParameters((Map)ImmutableMap.copyOf(parameters));
            context.addServlet(holder, entry.getKey());
        }
        List<String> list = Arrays.stream(connectorNames).map(name -> "@" + name).toList();
        context.setVirtualHosts(list);
        return context;
    }

    private static SecurityHandler createSecurityHandler(LoginService loginService) {
        Constraint constraint = Constraint.ALLOWED;
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setLoginService(loginService);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setConstraintMappings(Arrays.asList(constraintMapping));
        return securityHandler;
    }

    private static DelimitedRequestLog createDelimitedRequestLog(HttpServerConfig config, TraceTokenManager tokenManager, EventClient eventClient) throws IOException {
        File logFile = Path.of(config.getLogPath(), new String[0]).toFile();
        if (logFile.exists() && !logFile.isFile()) {
            throw new IOException(String.format("Log path %s exists but is not a file", logFile.getAbsolutePath()));
        }
        File logPath = logFile.getParentFile();
        if (!logPath.mkdirs() && !logPath.exists()) {
            throw new IOException(String.format("Cannot create %s and path does not already exist", logPath.getAbsolutePath()));
        }
        return new DelimitedRequestLog(config.getLogPath(), config.getLogHistory(), config.getLogQueueSize(), config.getLogMaxFileSize().toBytes(), tokenManager, eventClient, config.isLogCompressionEnabled());
    }

    private static Optional<KeyStore> tryLoadPemKeyStore(HttpServerConfig config) {
        File keyStoreFile = Path.of(config.getKeystorePath(), new String[0]).toFile();
        try {
            if (!PemReader.isPem((File)keyStoreFile)) {
                return Optional.empty();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading key store file: " + String.valueOf(keyStoreFile), e);
        }
        try {
            return Optional.of(PemReader.loadKeyStore((File)keyStoreFile, (File)keyStoreFile, Optional.ofNullable(config.getKeystorePassword())));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Error loading PEM key store: " + String.valueOf(keyStoreFile), e);
        }
    }

    private static Optional<KeyStore> tryLoadPemTrustStore(HttpServerConfig config) {
        File trustStoreFile = Path.of(config.getTrustStorePath(), new String[0]).toFile();
        try {
            if (!PemReader.isPem((File)trustStoreFile)) {
                return Optional.empty();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading trust store file: " + String.valueOf(trustStoreFile), e);
        }
        try {
            if (PemReader.readCertificateChain((File)trustStoreFile).isEmpty()) {
                throw new IllegalArgumentException("PEM trust store file does not contain any certificates: " + String.valueOf(trustStoreFile));
            }
            return Optional.of(PemReader.loadTrustStore((File)trustStoreFile));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Error loading PEM trust store: " + String.valueOf(trustStoreFile), e);
        }
    }

    @Managed
    public Long getDaysUntilCertificateExpiration() {
        return this.certificateExpiration.map(date -> ZonedDateTime.now().until((Temporal)date, ChronoUnit.DAYS)).orElse(null);
    }

    @Managed
    @Nested
    public ConnectionStats getHttpConnectionStats() {
        return this.httpConnectionStats;
    }

    @Managed
    @Nested
    public ConnectionStats getHttpsConnectionStats() {
        return this.httpsConnectionStats;
    }

    @Managed
    public int getLoggerQueueSize() {
        if (this.requestLog == null) {
            return 0;
        }
        return this.requestLog.getQueueSize();
    }

    @PostConstruct
    public void start() throws Exception {
        this.server.start();
        if (!this.registerErrorHandler) {
            this.server.setErrorHandler(null);
        }
        Preconditions.checkState((boolean)this.server.isStarted(), (Object)"server is not started");
    }

    @PreDestroy
    public void stop() throws Exception {
        this.server.setStopTimeout(1L);
        try {
            this.server.stop();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        if (this.requestLog != null) {
            this.requestLog.stop();
        }
    }

    @VisibleForTesting
    void join() throws InterruptedException {
        this.server.join();
    }

    private static Set<X509Certificate> loadAllX509Certificates(HttpServerConfig config) {
        ImmutableSet.Builder certificates = ImmutableSet.builder();
        if (config.isHttpsEnabled()) {
            try (InputStream keystoreInputStream = Files.newInputStream(Path.of(config.getKeystorePath(), new String[0]), new OpenOption[0]);){
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(keystoreInputStream, config.getKeystorePassword().toCharArray());
                for (String alias : Collections.list(keystore.aliases())) {
                    try {
                        Certificate certificate = keystore.getCertificate(alias);
                        if (!(certificate instanceof X509Certificate)) continue;
                        certificates.add((Object)((X509Certificate)certificate));
                    }
                    catch (KeyStoreException keyStoreException) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return certificates.build();
    }

    private static ServerConnector createServerConnector(ServerSocketChannel channel, Server server, Executor executor, Scheduler scheduler, int acceptors, int selectors, ConnectionFactory ... factories) throws IOException {
        ServerConnector connector = new ServerConnector(server, executor, scheduler, null, acceptors, selectors, factories);
        connector.open(channel);
        return connector;
    }
}

