/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.facebook.airlift.units.Duration;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.core.Response;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@Beta
public class AsyncResponseHandler {
    private final AsyncResponse asyncResponse;
    private final WeakReference<Future<?>> futureResponseReference;

    private AsyncResponseHandler(AsyncResponse asyncResponse, ListenableFuture<?> futureResponse) {
        this.asyncResponse = Objects.requireNonNull(asyncResponse, "asyncResponse is null");
        this.futureResponseReference = new WeakReference<Future>((Future)Objects.requireNonNull(futureResponse, "futureResponse is null"));
    }

    public static AsyncResponseHandler bindAsyncResponse(AsyncResponse asyncResponse, ListenableFuture<?> futureResponse, Executor httpResponseExecutor) {
        Futures.addCallback(futureResponse, AsyncResponseHandler.toFutureCallback(asyncResponse), (Executor)httpResponseExecutor);
        return new AsyncResponseHandler(asyncResponse, futureResponse);
    }

    public AsyncResponseHandler withTimeout(Duration timeout) {
        return this.withTimeout(timeout, Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)("Timed out after waiting for " + String.valueOf(timeout.convertToMostSuccinctTimeUnit()))).build());
    }

    public AsyncResponseHandler withTimeout(Duration timeout, Response timeoutResponse) {
        return this.withTimeout(timeout, () -> timeoutResponse);
    }

    public AsyncResponseHandler withTimeout(Duration timeout, Supplier<Response> timeoutResponse) {
        this.asyncResponse.setTimeoutHandler(asyncResponse -> {
            asyncResponse.resume(timeoutResponse.get());
            this.cancelFuture();
        });
        this.asyncResponse.setTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    private void cancelFuture() {
        Future futureResponse = (Future)this.futureResponseReference.get();
        if (futureResponse != null) {
            try {
                futureResponse.cancel(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static <T> FutureCallback<T> toFutureCallback(final AsyncResponse asyncResponse) {
        return new FutureCallback<T>(){

            public void onSuccess(T value) {
                Preconditions.checkArgument((!(value instanceof Response.ResponseBuilder) ? 1 : 0) != 0, (Object)"Value is a ResponseBuilder. Did you forget to call build?");
                asyncResponse.resume(value);
            }

            public void onFailure(Throwable t) {
                asyncResponse.resume(t);
            }
        };
    }
}

