/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.facebook.airlift.http.server.DelimitedRequestLog;
import com.facebook.airlift.http.server.DoubleSummaryStats;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.EventsHandler;

public class HttpServerChannelListener
extends EventsHandler {
    private static final String REQUEST_BEFORE_HANDLE = HttpServerChannelListener.class.getName() + ".before_handle";
    private static final String REQUEST_RESPONSE_BEGIN = HttpServerChannelListener.class.getName() + ".response_begin";
    private static final String RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE = HttpServerChannelListener.class.getName() + ".response_content_timestamps";
    private static final String RESPONSE_CONTENT_SIZES_ATTRIBUTE = HttpServerChannelListener.class.getName() + ".response_content_sizes";
    private static final String REQUEST_AFTER_HANDLE = HttpServerChannelListener.class.getName() + ".after_handle";
    private final DelimitedRequestLog logger;

    public HttpServerChannelListener(DelimitedRequestLog logger, Handler handler) {
        super(handler);
        this.logger = Objects.requireNonNull(logger, "logger is null");
    }

    protected void onBeforeHandling(Request request) {
        request.setAttribute(REQUEST_BEFORE_HANDLE, (Object)System.nanoTime());
    }

    protected void onResponseBegin(Request request, int status, HttpFields headers) {
        request.setAttribute(REQUEST_RESPONSE_BEGIN, (Object)System.nanoTime());
        if (request.getAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE) == null) {
            request.setAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE, new ArrayList());
        }
    }

    protected void onResponseWrite(Request request, boolean last, ByteBuffer content) {
        if (request.getAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE) == null) {
            request.setAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE, new ArrayList());
        }
        List contentTimestamps = (List)request.getAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE);
        contentTimestamps.add(System.nanoTime());
        if (request.getAttribute(RESPONSE_CONTENT_SIZES_ATTRIBUTE) == null) {
            request.setAttribute(RESPONSE_CONTENT_SIZES_ATTRIBUTE, (Object)new AtomicLong(0L));
        }
        AtomicLong responseSize = (AtomicLong)request.getAttribute(RESPONSE_CONTENT_SIZES_ATTRIBUTE);
        responseSize.addAndGet(content.remaining());
    }

    protected void onComplete(Request request, @Nullable Throwable failure) {
        this.onCompleteHelper(request, -1, HttpFields.EMPTY, failure);
    }

    protected void onComplete(Request request, int status, HttpFields headers, @Nullable Throwable failure) {
        this.onCompleteHelper(request, status, headers, failure);
    }

    private void onCompleteHelper(Request request, int status, HttpFields headers, @Nullable Throwable failure) {
        Long afterHandleMillis;
        long requestBeginTime = (Long)request.getAttribute(REQUEST_BEFORE_HANDLE);
        List contentTimestamps = Optional.ofNullable((List)request.getAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE)).orElseGet(ArrayList::new);
        long firstToLastContentTimeInMillis = -1L;
        if (!contentTimestamps.isEmpty()) {
            firstToLastContentTimeInMillis = TimeUnit.NANOSECONDS.toMillis((Long)contentTimestamps.get(contentTimestamps.size() - 1) - (Long)contentTimestamps.get(0));
        }
        if ((afterHandleMillis = (Long)request.getAttribute(REQUEST_AFTER_HANDLE)) == null) {
            afterHandleMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        }
        long responseSize = Optional.ofNullable((AtomicLong)request.getAttribute(RESPONSE_CONTENT_SIZES_ATTRIBUTE)).map(AtomicLong::get).orElse(0L);
        this.logger.log(request, responseSize, status, headers, requestBeginTime, afterHandleMillis, firstToLastContentTimeInMillis, HttpServerChannelListener.processContentTimestamps(contentTimestamps));
    }

    protected void onAfterHandling(Request request, boolean handled, Throwable failure) {
        request.setAttribute(REQUEST_AFTER_HANDLE, (Object)System.nanoTime());
    }

    @Nullable
    private static DoubleSummaryStats processContentTimestamps(List<Long> contentTimestamps) {
        Objects.requireNonNull(contentTimestamps, "contentTimestamps is null");
        if (contentTimestamps.size() == 0 || contentTimestamps.size() == 1) {
            return null;
        }
        DoubleSummaryStatistics statistics = new DoubleSummaryStatistics();
        long previousTimestamp = contentTimestamps.get(0);
        for (int i = 1; i < contentTimestamps.size(); ++i) {
            long timestamp = contentTimestamps.get(i);
            statistics.accept(TimeUnit.NANOSECONDS.toMillis(timestamp - previousTimestamp));
            previousTimestamp = timestamp;
        }
        return new DoubleSummaryStats(statistics);
    }
}

