/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.facebook.airlift.http.server.AuthenticationException;
import com.facebook.airlift.http.server.Authenticator;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;

public class AuthenticationFilter
implements Filter {
    private final List<Authenticator> authenticators;

    @Inject
    public AuthenticationFilter(List<Authenticator> authenticators) {
        this.authenticators = ImmutableList.copyOf((Collection)Objects.requireNonNull(authenticators, "authenticators is null"));
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain nextFilter) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!request.isSecure() || this.authenticators.isEmpty()) {
            nextFilter.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        LinkedHashSet authenticateHeaders = new LinkedHashSet();
        for (Authenticator authenticator : this.authenticators) {
            Principal principal;
            try {
                principal = authenticator.authenticate(request);
            }
            catch (AuthenticationException e) {
                if (e.getMessage() != null) {
                    messages.add(e.getMessage());
                }
                e.getAuthenticateHeader().ifPresent(authenticateHeaders::add);
                continue;
            }
            nextFilter.doFilter(AuthenticationFilter.withPrincipal(request, principal), (ServletResponse)response);
            return;
        }
        AuthenticationFilter.skipRequestBody(request);
        for (String value : authenticateHeaders) {
            response.addHeader("WWW-Authenticate", value);
        }
        if (messages.isEmpty()) {
            messages.add("Unauthorized");
        }
        String error = Joiner.on((String)" | ").join(messages);
        response.setStatus(401);
        response.setContentType(MediaType.PLAIN_TEXT_UTF_8.toString());
        try (PrintWriter writer = response.getWriter();){
            writer.write(error);
        }
    }

    private static ServletRequest withPrincipal(HttpServletRequest request, final Principal principal) {
        Objects.requireNonNull(principal, "principal is null");
        return new HttpServletRequestWrapper(request){

            public Principal getUserPrincipal() {
                return principal;
            }
        };
    }

    private static void skipRequestBody(HttpServletRequest request) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            inputStream.transferTo(OutputStream.nullOutputStream());
        }
    }
}

