/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class ClassPathResourceHandler
extends Handler.Wrapper {
    private static final MimeTypes MIME_TYPES;
    private static final byte[] EMPTY_BYTE;
    private final String baseUri;
    private final String classPathResourceBase;
    private final List<String> welcomeFiles;
    private final Map<String, String> extraHeaders;

    public ClassPathResourceHandler(String baseUri, String classPathResourceBase, String ... welcomeFiles) {
        this(baseUri, classPathResourceBase, (List<String>)ImmutableList.copyOf((Object[])welcomeFiles), (Map<String, String>)ImmutableMap.of());
    }

    /*
     * WARNING - void declaration
     */
    public ClassPathResourceHandler(String baseUri, String classPathResourceBase, List<String> welcomeFiles, Map<String, String> extraHeaders) {
        Objects.requireNonNull(baseUri, "baseUri is null");
        Objects.requireNonNull(classPathResourceBase, "classPathResourceBase is null");
        Objects.requireNonNull(welcomeFiles, "welcomeFiles is null");
        Preconditions.checkArgument((((String)baseUri).equals("/") || !((String)baseUri).endsWith("/") ? 1 : 0) != 0, (String)"baseUri should not end with a slash: %s", (Object)baseUri);
        baseUri = ((String)baseUri).startsWith("/") ? baseUri : "/" + (String)baseUri;
        this.baseUri = baseUri = ((String)baseUri).equals("/") ? "" : baseUri;
        this.classPathResourceBase = classPathResourceBase;
        ImmutableList.Builder files = ImmutableList.builder();
        for (String string : welcomeFiles) {
            void var7_7;
            if (!string.startsWith("/")) {
                String string2 = "/" + string;
            }
            files.add((Object)var7_7);
        }
        this.welcomeFiles = files.build();
        this.extraHeaders = ImmutableMap.copyOf(extraHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(Request request, Response response, Callback callback) {
        String resourcePath = this.getResourcePath(request);
        if (resourcePath == null) {
            return false;
        }
        if (resourcePath.isEmpty()) {
            response.setStatus(307);
            response.getHeaders().add("Location", Response.toRedirectURI((Request)request, (String)(this.baseUri + "/")));
            callback.succeeded();
            return true;
        }
        URL resource = this.getResource(resourcePath);
        if (resource == null) {
            return false;
        }
        String method = request.getMethod();
        boolean skipContent = false;
        if (!HttpMethod.GET.is(method)) {
            if (HttpMethod.HEAD.is(method)) {
                skipContent = true;
            } else {
                callback.failed((Throwable)new HttpException.IllegalArgumentException(405));
                return true;
            }
        }
        InputStream resourceStream = null;
        try {
            resourceStream = resource.openStream();
            String contentType = MIME_TYPES.getMimeByExtension(resource.toString());
            response.getHeaders().add(HttpHeader.CONTENT_TYPE, contentType);
            this.extraHeaders.forEach((name, value) -> response.getHeaders().add(name, value));
            if (skipContent) {
                callback.succeeded();
                boolean bl = true;
                return bl;
            }
            try (OutputStream out = Response.asBufferedOutputStream((Request)request, (Response)response);){
                resourceStream.transferTo(out);
            }
            response.write(true, ByteBuffer.wrap(EMPTY_BYTE), null);
            callback.succeeded();
        }
        catch (Exception e) {
            callback.failed((Throwable)e);
        }
        finally {
            ClassPathResourceHandler.closeQuietly(resourceStream);
        }
        return true;
    }

    @Nullable
    private String getResourcePath(Request request) {
        String pathInfo = request.getHttpURI().getPath();
        if (pathInfo == null || !pathInfo.startsWith(this.baseUri)) {
            return null;
        }
        if (!(pathInfo = pathInfo.substring(this.baseUri.length())).startsWith("/") && !pathInfo.isEmpty()) {
            return null;
        }
        return pathInfo;
    }

    private URL getResource(String resourcePath) {
        Preconditions.checkArgument((boolean)resourcePath.startsWith("/"), (String)"resourcePath does not start with a slash: %s", (Object)resourcePath);
        if (!"/".equals(resourcePath)) {
            return ((Object)((Object)this)).getClass().getClassLoader().getResource(this.classPathResourceBase + resourcePath);
        }
        for (String welcomeFile : this.welcomeFiles) {
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.classPathResourceBase + welcomeFile);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private static void closeQuietly(@Nullable InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        EMPTY_BYTE = new byte[0];
        MIME_TYPES = new MimeTypes();
    }
}

