/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import ch.qos.logback.core.LayoutBase;
import com.facebook.airlift.http.server.DoubleSummaryStats;
import com.facebook.airlift.http.server.HttpRequestEvent;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class HttpLogLayout
extends LayoutBase<HttpRequestEvent> {
    private static final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());

    public String doLayout(HttpRequestEvent event) {
        StringBuilder builder = new StringBuilder();
        String contentInterarrivalStats = null;
        DoubleSummaryStats stats = event.getResponseContentInterarrivalStats();
        if (stats != null) {
            contentInterarrivalStats = String.format("%.2f, %.2f, %.2f, %d", stats.getMin(), stats.getAverage(), stats.getMax(), stats.getCount());
        }
        builder.append(ISO_FORMATTER.format(event.getTimeStamp())).append('\t').append(event.getClientAddress()).append('\t').append(event.getMethod()).append('\t').append(event.getRequestUri()).append('\t').append(event.getUser()).append('\t').append(event.getAgent()).append('\t').append(event.getResponseSize()).append('\t').append(event.getResponseCode()).append('\t').append(event.getRequestSize()).append('\t').append(event.getTimeToLastByte()).append('\t').append(event.getTraceToken()).append('\t').append(event.getProtocolVersion()).append('\t').append(event.getBeginToDispatchMillis()).append('\t').append(event.getAfterDispatchMillis()).append('\t').append(event.getFirstToLastContentTimeInMillis()).append('\t').append(contentInterarrivalStats).append('\n');
        return builder.toString();
    }
}

