/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.google.common.base.Preconditions;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;

class TimingFilter
implements Filter {
    public static final String FIRST_BYTE_TIME = TimingFilter.class.getName() + ".FIRST_BYTE_TIME";

    TimingFilter() {
    }

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        TimedResponse response = new TimedResponse((HttpServletResponse)servletResponse);
        try {
            chain.doFilter(servletRequest, (ServletResponse)response);
        }
        finally {
            Long firstByteTime = response.getFirstByteTime();
            if (firstByteTime != null) {
                servletRequest.setAttribute(FIRST_BYTE_TIME, (Object)firstByteTime);
            }
        }
    }

    public void destroy() {
    }

    private static class TimedResponse
    extends HttpServletResponseWrapper {
        private TimedServletOutputStream outputStream;
        private TimedPrintWriter printWriter;

        private TimedResponse(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            Preconditions.checkState((this.printWriter == null ? 1 : 0) != 0, (Object)"getWriter() has already been called");
            if (this.outputStream == null) {
                this.outputStream = new TimedServletOutputStream(super.getOutputStream());
            }
            return this.outputStream;
        }

        public PrintWriter getWriter() throws IOException {
            Preconditions.checkState((this.outputStream == null ? 1 : 0) != 0, (Object)"getOutputStream() has already been called");
            if (this.printWriter == null) {
                this.printWriter = new TimedPrintWriter(super.getWriter());
            }
            return this.printWriter;
        }

        public Long getFirstByteTime() {
            if (this.outputStream != null) {
                return this.outputStream.getFirstByteTime();
            }
            if (this.printWriter != null) {
                return this.printWriter.getFirstByteTime();
            }
            return null;
        }
    }

    private static class TimedPrintWriter
    extends PrintWriter {
        private Long firstByteTime;

        private TimedPrintWriter(PrintWriter delegate) {
            super(delegate);
        }

        public Long getFirstByteTime() {
            return this.firstByteTime;
        }

        private void recordFirstByteTime() {
            if (this.firstByteTime == null) {
                this.firstByteTime = System.currentTimeMillis();
            }
        }

        @Override
        public void write(int c) {
            this.recordFirstByteTime();
            super.write(c);
        }

        @Override
        public void write(char[] buf, int off, int len) {
            this.recordFirstByteTime();
            super.write(buf, off, len);
        }

        @Override
        public void write(char[] buf) {
            this.recordFirstByteTime();
            super.write(buf);
        }

        @Override
        public void write(String s, int off, int len) {
            this.recordFirstByteTime();
            super.write(s, off, len);
        }

        @Override
        public void write(String s) {
            this.recordFirstByteTime();
            super.write(s);
        }

        @Override
        public void print(boolean b) {
            this.recordFirstByteTime();
            super.print(b);
        }

        @Override
        public void print(char c) {
            this.recordFirstByteTime();
            super.print(c);
        }

        @Override
        public void print(int i) {
            this.recordFirstByteTime();
            super.print(i);
        }

        @Override
        public void print(long l) {
            this.recordFirstByteTime();
            super.print(l);
        }

        @Override
        public void print(float f) {
            this.recordFirstByteTime();
            super.print(f);
        }

        @Override
        public void print(double d) {
            this.recordFirstByteTime();
            super.print(d);
        }

        @Override
        public void print(char[] s) {
            this.recordFirstByteTime();
            super.print(s);
        }

        @Override
        public void print(String s) {
            this.recordFirstByteTime();
            super.print(s);
        }

        @Override
        public void print(Object obj) {
            this.recordFirstByteTime();
            super.print(obj);
        }

        @Override
        public void println() {
            this.recordFirstByteTime();
            super.println();
        }

        @Override
        public void println(boolean x) {
            this.recordFirstByteTime();
            super.println(x);
        }

        @Override
        public void println(char x) {
            this.recordFirstByteTime();
            super.println(x);
        }

        @Override
        public void println(int x) {
            this.recordFirstByteTime();
            super.println(x);
        }

        @Override
        public void println(long x) {
            this.recordFirstByteTime();
            super.println(x);
        }

        @Override
        public void println(float x) {
            this.recordFirstByteTime();
            super.println(x);
        }

        @Override
        public void println(double x) {
            this.recordFirstByteTime();
            super.println(x);
        }

        @Override
        public void println(char[] x) {
            this.recordFirstByteTime();
            super.println(x);
        }

        @Override
        public void println(String x) {
            this.recordFirstByteTime();
            super.println(x);
        }

        @Override
        public void println(Object x) {
            this.recordFirstByteTime();
            super.println(x);
        }

        @Override
        public PrintWriter printf(String format, Object ... args) {
            this.recordFirstByteTime();
            super.printf(format, args);
            return this;
        }

        @Override
        public PrintWriter printf(Locale l, String format, Object ... args) {
            this.recordFirstByteTime();
            super.printf(l, format, args);
            return this;
        }

        @Override
        public PrintWriter format(String format, Object ... args) {
            this.recordFirstByteTime();
            super.format(format, args);
            return this;
        }

        @Override
        public PrintWriter format(Locale l, String format, Object ... args) {
            this.recordFirstByteTime();
            super.format(l, format, args);
            return this;
        }

        @Override
        public PrintWriter append(CharSequence csq) {
            this.recordFirstByteTime();
            super.append(csq);
            return this;
        }

        @Override
        public PrintWriter append(CharSequence csq, int start, int end) {
            this.recordFirstByteTime();
            super.append(csq, start, end);
            return this;
        }

        @Override
        public PrintWriter append(char c) {
            this.recordFirstByteTime();
            super.append(c);
            return this;
        }
    }

    private static class TimedServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream delegate;
        private Long firstByteTime;

        private TimedServletOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
        }

        public Long getFirstByteTime() {
            return this.firstByteTime;
        }

        private void recordFirstByteTime() {
            if (this.firstByteTime == null) {
                this.firstByteTime = System.currentTimeMillis();
            }
        }

        public void write(int b) throws IOException {
            this.recordFirstByteTime();
            this.delegate.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.recordFirstByteTime();
            this.delegate.write(b);
        }

        public void print(String s) throws IOException {
            this.recordFirstByteTime();
            this.delegate.print(s);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.recordFirstByteTime();
            this.delegate.write(b, off, len);
        }

        public void print(boolean b) throws IOException {
            this.recordFirstByteTime();
            this.delegate.print(b);
        }

        public void print(char c) throws IOException {
            this.recordFirstByteTime();
            this.delegate.print(c);
        }

        public void print(int i) throws IOException {
            this.recordFirstByteTime();
            this.delegate.print(i);
        }

        public void print(long l) throws IOException {
            this.recordFirstByteTime();
            this.delegate.print(l);
        }

        public void print(float f) throws IOException {
            this.recordFirstByteTime();
            this.delegate.print(f);
        }

        public void print(double d) throws IOException {
            this.recordFirstByteTime();
            this.delegate.print(d);
        }

        public void println() throws IOException {
            this.recordFirstByteTime();
            this.delegate.println();
        }

        public void println(String s) throws IOException {
            this.recordFirstByteTime();
            this.delegate.println(s);
        }

        public void println(boolean b) throws IOException {
            this.recordFirstByteTime();
            this.delegate.println(b);
        }

        public void println(char c) throws IOException {
            this.recordFirstByteTime();
            this.delegate.println(c);
        }

        public void println(int i) throws IOException {
            this.recordFirstByteTime();
            this.delegate.println(i);
        }

        public void println(long l) throws IOException {
            this.recordFirstByteTime();
            this.delegate.println(l);
        }

        public void println(float f) throws IOException {
            this.recordFirstByteTime();
            this.delegate.println(f);
        }

        public void println(double d) throws IOException {
            this.recordFirstByteTime();
            this.delegate.println(d);
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.delegate.setWriteListener(writeListener);
        }
    }
}

