/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.utils.jetty;

import com.facebook.airlift.concurrent.ConcurrentScheduledExecutor;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.thread.Scheduler;

public class ConcurrentScheduler
extends AbstractLifeCycle
implements Scheduler {
    private final int schedulerCount;
    private final int threadsPerScheduler;
    private final String threadBaseName;
    @GuardedBy(value="this")
    private volatile ConcurrentScheduledExecutor concurrentScheduler;

    public ConcurrentScheduler(int schedulerCount, int threadsPerScheduler, String threadBaseName) {
        Preconditions.checkArgument((schedulerCount > 0 ? 1 : 0) != 0, (Object)"schedulerCount must be at least one");
        Preconditions.checkArgument((threadsPerScheduler > 0 ? 1 : 0) != 0, (Object)"threadsPerScheduler must be at least one");
        this.schedulerCount = schedulerCount;
        this.threadsPerScheduler = threadsPerScheduler;
        this.threadBaseName = Objects.requireNonNull(threadBaseName, "threadBaseName is null");
    }

    public static Scheduler createConcurrentScheduler(String threadBaseName, int concurrency, int totalThreads) {
        Preconditions.checkArgument((concurrency >= 1 ? 1 : 0) != 0, (Object)"concurrency must be at least one");
        int threadsPerScheduler = Math.max(1, totalThreads / concurrency);
        return new ConcurrentScheduler(concurrency, threadsPerScheduler, threadBaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        ConcurrentScheduler concurrentScheduler = this;
        synchronized (concurrentScheduler) {
            if (this.concurrentScheduler == null) {
                this.concurrentScheduler = new ConcurrentScheduledExecutor(this.schedulerCount, this.threadsPerScheduler, this.threadBaseName, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        ConcurrentScheduler concurrentScheduler = this;
        synchronized (concurrentScheduler) {
            if (this.concurrentScheduler != null) {
                this.concurrentScheduler.shutdownNow();
                this.concurrentScheduler = null;
            }
        }
    }

    public Scheduler.Task schedule(Runnable task, long delay, TimeUnit unit) {
        ConcurrentScheduledExecutor scheduler = this.concurrentScheduler;
        if (scheduler == null) {
            return () -> false;
        }
        ScheduledFuture result = scheduler.schedule(task, delay, unit);
        return () -> result.cancel(false);
    }
}

