/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jaxrs.testing;

import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.testing.TestingHttpClient;
import com.facebook.airlift.http.client.testing.TestingResponse;
import com.facebook.airlift.log.Logger;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MoreCollectors;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.inmemory.InMemoryTestContainerFactory;
import org.glassfish.jersey.test.spi.TestContainer;

public class JaxrsTestingHttpProcessor
implements TestingHttpClient.Processor {
    private static final Logger log = Logger.get(JaxrsTestingHttpProcessor.class);
    private final Client client;
    private boolean trace;

    public JaxrsTestingHttpProcessor(URI baseUri, Object ... jaxRsSingletons) {
        ImmutableSet jaxRsSingletonsSet = ImmutableSet.copyOf((Object[])jaxRsSingletons);
        Application application = new Application((Set)jaxRsSingletonsSet){
            final /* synthetic */ Set val$jaxRsSingletonsSet;
            {
                this.val$jaxRsSingletonsSet = set;
            }

            public Set<Object> getSingletons() {
                return this.val$jaxRsSingletonsSet;
            }
        };
        TestContainer testContainer = new InMemoryTestContainerFactory().create(baseUri, DeploymentContext.newInstance((Application)application));
        ClientConfig clientConfig = testContainer.getClientConfig();
        this.client = JerseyClientBuilder.createClient((Configuration)clientConfig);
    }

    public JaxrsTestingHttpProcessor setTrace(boolean enabled) {
        this.trace = enabled;
        return this;
    }

    public com.facebook.airlift.http.client.Response handle(Request request) throws Exception {
        Response result;
        Invocation invocation;
        MultivaluedHashMap requestHeaders = new MultivaluedHashMap();
        for (Map.Entry entry : request.getHeaders().entries()) {
            requestHeaders.add((Object)((String)entry.getKey()), entry.getValue());
        }
        Invocation.Builder invocationBuilder = this.client.target(request.getUri()).request().headers((MultivaluedMap)requestHeaders);
        if (request.getBodyGenerator() == null) {
            invocation = invocationBuilder.build(request.getMethod());
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            request.getBodyGenerator().write((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            Entity entity = Entity.entity((Object)bytes, (String)((String)((List)requestHeaders.get((Object)"Content-Type")).stream().collect(MoreCollectors.onlyElement())));
            invocation = invocationBuilder.build(request.getMethod(), entity);
        }
        try {
            result = (Response)invocation.invoke(Response.class);
        }
        catch (ProcessingException exception) {
            if (this.trace) {
                log.warn(exception.getCause(), "%-8s %s -> Exception", new Object[]{request.getMethod(), request.getUri()});
            }
            if (exception.getCause() instanceof Exception) {
                throw (Exception)exception.getCause();
            }
            throw exception;
        }
        catch (Throwable throwable) {
            if (this.trace) {
                log.warn(throwable, "%-8s %s -> Fail", new Object[]{request.getMethod(), request.getUri()});
            }
            throw throwable;
        }
        ImmutableListMultimap.Builder responseHeaders = ImmutableListMultimap.builder();
        for (Map.Entry headerEntry : result.getStringHeaders().entrySet()) {
            for (String value : (List)headerEntry.getValue()) {
                responseHeaders.put((Object)((String)headerEntry.getKey()), (Object)value);
            }
        }
        if (this.trace) {
            log.warn("%-8s %s -> OK", new Object[]{request.getMethod(), request.getUri()});
        }
        return new TestingResponse(HttpStatus.fromStatusCode((int)result.getStatus()), (ListMultimap)responseHeaders.build(), (byte[])result.readEntity(byte[].class));
    }
}

