/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jaxrs;

import com.facebook.airlift.jaxrs.JaxrsResource;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import java.util.Objects;

public class JaxrsBinder {
    private final Multibinder<Object> resourceBinder;
    private final Binder binder;

    private JaxrsBinder(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass()});
        this.resourceBinder = Multibinder.newSetBinder((Binder)binder, Object.class, JaxrsResource.class).permitDuplicates();
    }

    public static JaxrsBinder jaxrsBinder(Binder binder) {
        return new JaxrsBinder(binder);
    }

    public void bind(Class<?> implementation) {
        this.binder.bind(implementation).in(Scopes.SINGLETON);
        this.resourceBinder.addBinding().to(implementation).in(Scopes.SINGLETON);
    }

    public void bind(TypeLiteral<?> implementation) {
        this.binder.bind(implementation).in(Scopes.SINGLETON);
        this.resourceBinder.addBinding().to(implementation).in(Scopes.SINGLETON);
    }

    public void bind(Key<?> targetKey) {
        this.binder.bind(targetKey).in(Scopes.SINGLETON);
        this.resourceBinder.addBinding().to(targetKey).in(Scopes.SINGLETON);
    }

    public void bindInstance(Object instance) {
        this.resourceBinder.addBinding().toInstance(instance);
    }
}

