/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jaxrs;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.http.server.HttpServerConfig;
import com.facebook.airlift.http.server.TheServlet;
import com.facebook.airlift.jaxrs.AuthorizationFilter;
import com.facebook.airlift.jaxrs.JaxrsBinder;
import com.facebook.airlift.jaxrs.JaxrsResource;
import com.facebook.airlift.jaxrs.JsonMapper;
import com.facebook.airlift.jaxrs.OverrideMethodFilter;
import com.facebook.airlift.jaxrs.ParsingExceptionMapper;
import com.facebook.airlift.jaxrs.SmileMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class JaxrsModule
extends AbstractConfigurationAwareModule {
    public JaxrsModule() {
    }

    @Deprecated
    public JaxrsModule(boolean requireExplicitBindings) {
        Preconditions.checkArgument((boolean)requireExplicitBindings, (Object)"non-explicit bindings are no longer supported");
    }

    protected void setup(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(Application.class).to(JaxRsApplication.class).in(Scopes.SINGLETON);
        binder.bind(Servlet.class).annotatedWith(TheServlet.class).to(Key.get(ServletContainer.class));
        JaxrsBinder.jaxrsBinder(binder).bind(JsonMapper.class);
        JaxrsBinder.jaxrsBinder(binder).bind(SmileMapper.class);
        JaxrsBinder.jaxrsBinder(binder).bind(ParsingExceptionMapper.class);
        JaxrsBinder.jaxrsBinder(binder).bind(OverrideMethodFilter.class);
        if (((HttpServerConfig)this.buildConfigObject(HttpServerConfig.class)).isAuthorizationEnabled()) {
            JaxrsBinder.jaxrsBinder(binder).bind(AuthorizationFilter.class);
        }
        Multibinder.newSetBinder((Binder)binder, Object.class, JaxrsResource.class).permitDuplicates();
    }

    @Provides
    public static ServletContainer createServletContainer(ResourceConfig resourceConfig) {
        return new ServletContainer(resourceConfig);
    }

    @Provides
    public static ResourceConfig createResourceConfig(Application application) {
        return ResourceConfig.forApplication((Application)application);
    }

    @Provides
    @TheServlet
    public static Map<String, String> createTheServletParams() {
        HashMap<String, String> initParams = new HashMap<String, String>();
        return initParams;
    }

    public static class JaxRsApplication
    extends Application {
        private final Set<Object> jaxRsSingletons;

        @Inject
        public JaxRsApplication(@JaxrsResource Set<Object> jaxRsSingletons) {
            this.jaxRsSingletons = ImmutableSet.copyOf(jaxRsSingletons);
        }

        public Set<Object> getSingletons() {
            return this.jaxRsSingletons;
        }
    }
}

