/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jaxrs;

import com.facebook.airlift.jaxrs.BaseMapper;
import com.facebook.airlift.jaxrs.JsonMapperParsingException;
import com.facebook.airlift.log.Logger;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.util.JSONPObject;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/json", "text/json"})
@Produces(value={"application/json", "text/json"})
public class JsonMapper
extends BaseMapper {
    public static final Logger log = Logger.get(JsonMapper.class);
    private final ObjectMapper objectMapper;
    private final AtomicReference<UriInfo> uriInfo = new AtomicReference();

    @Inject
    public JsonMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Context
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo.set(uriInfo);
    }

    private UriInfo getUriInfo() {
        return this.uriInfo.get();
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException {
        Object object;
        try {
            JsonParser jsonParser = this.objectMapper.getFactory().createParser(inputStream);
            jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            object = this.objectMapper.readValue(jsonParser, this.objectMapper.getTypeFactory().constructType(genericType));
        }
        catch (Exception e) {
            if (e instanceof IOException && !(e instanceof JsonProcessingException) && !(e instanceof EOFException)) {
                throw e;
            }
            log.debug((Throwable)e, "Invalid json for Java type %s", new Object[]{type});
            throw new JsonMapperParsingException(type, (Throwable)e);
        }
        return object;
    }

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        String jsonpFunctionName;
        httpHeaders.add((Object)"X-Content-Type-Options", (Object)"nosniff");
        JsonFactory jsonFactory = this.objectMapper.getFactory();
        jsonFactory.setCharacterEscapes((CharacterEscapes)HTMLCharacterEscapes.INSTANCE);
        JsonGenerator jsonGenerator = jsonFactory.createGenerator(outputStream, JsonEncoding.UTF8);
        jsonGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        if (this.isPrettyPrintRequested()) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        JavaType rootType = null;
        if (genericType != null && value != null && genericType.getClass() != Class.class && (rootType = this.objectMapper.getTypeFactory().constructType(genericType)).getRawClass() == Object.class) {
            rootType = null;
        }
        if ((jsonpFunctionName = this.getJsonpFunctionName()) != null) {
            value = new JSONPObject(jsonpFunctionName, value, rootType);
            rootType = null;
        }
        ObjectWriter writer = rootType != null ? this.objectMapper.writerFor(rootType) : this.objectMapper.writer();
        try {
            writer.writeValue(jsonGenerator, value);
            outputStream.write(10);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private boolean isPrettyPrintRequested() {
        UriInfo uriInfo = this.getUriInfo();
        if (uriInfo == null) {
            return false;
        }
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        return queryParameters != null && queryParameters.containsKey((Object)"pretty");
    }

    private String getJsonpFunctionName() {
        UriInfo uriInfo = this.getUriInfo();
        if (uriInfo == null) {
            return null;
        }
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        if (queryParameters == null) {
            return null;
        }
        return (String)queryParameters.getFirst((Object)"jsonp");
    }

    private static class HTMLCharacterEscapes
    extends CharacterEscapes {
        private static final HTMLCharacterEscapes INSTANCE = new HTMLCharacterEscapes();
        private final int[] asciiEscapes;

        private HTMLCharacterEscapes() {
            int[] esc = CharacterEscapes.standardAsciiEscapesForJSON();
            esc[60] = -1;
            esc[62] = -1;
            esc[38] = -1;
            esc[39] = -1;
            this.asciiEscapes = esc;
        }

        public int[] getEscapeCodesForAscii() {
            return this.asciiEscapes;
        }

        public SerializableString getEscapeSequence(int ch) {
            return null;
        }
    }
}

