/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jaxrs;

import com.facebook.airlift.http.server.AuthorizationResult;
import com.facebook.airlift.http.server.Authorizer;
import com.facebook.airlift.http.server.HttpServerConfig;
import com.facebook.airlift.jaxrs.RoleMapping;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.security.Principal;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Provider
public class AuthorizationFilter
implements ContainerRequestFilter {
    private final Authorizer authorizer;
    private final HttpServerConfig.AuthorizationPolicy authorizationPolicy;
    private final Set<String> defaultAllowedRoles;
    private final Map<Class<?>, Map<String, String>> roleMaps;
    private final boolean allowUnsecureRequestsInAuthorizer;
    @Context
    private ResourceInfo resourceInfo;

    @Inject
    public AuthorizationFilter(Authorizer authorizer, HttpServerConfig httpServerConfig, @RoleMapping Map<Class<?>, Map<String, String>> roleMaps) {
        this(authorizer, httpServerConfig.getDefaultAuthorizationPolicy(), httpServerConfig.getDefaultAllowedRoles(), roleMaps, httpServerConfig.isAllowUnsecureRequestsInAuthorizer());
    }

    @VisibleForTesting
    public AuthorizationFilter(Authorizer authorizer, HttpServerConfig.AuthorizationPolicy authorizationPolicy, Set<String> defaultAllowedRoles, Map<Class<?>, Map<String, String>> roleMaps, boolean allowUnsecureRequestsInAuthorizer) {
        this.authorizer = Objects.requireNonNull(authorizer, "authorizer is null");
        this.authorizationPolicy = Objects.requireNonNull(authorizationPolicy, "authorizationPolicy is null");
        this.defaultAllowedRoles = Objects.requireNonNull(defaultAllowedRoles, "defaultAllowedRoles is null");
        this.roleMaps = Objects.requireNonNull(roleMaps, "roleMaps is null");
        this.allowUnsecureRequestsInAuthorizer = allowUnsecureRequestsInAuthorizer;
    }

    public void filter(ContainerRequestContext request) {
        AuthorizationResult result;
        if (!request.getSecurityContext().isSecure() && this.allowUnsecureRequestsInAuthorizer) {
            return;
        }
        Principal principal = request.getSecurityContext().getUserPrincipal();
        if (principal == null) {
            request.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Request principal is missing.").build());
            return;
        }
        Optional<Set<String>> allowedRoles = this.getAllowedRoles();
        if (!allowedRoles.isPresent()) {
            switch (this.authorizationPolicy) {
                case ALLOW: {
                    return;
                }
                case DENY: {
                    request.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)String.format("Principal %s is not allowed to access the resource. Reason: denied by default policy", principal.getName())).build());
                    return;
                }
                case DEFAULT_ROLES: {
                    allowedRoles = Optional.of(this.defaultAllowedRoles);
                    break;
                }
            }
        } else if (this.roleMaps.containsKey(this.resourceInfo.getResourceClass())) {
            allowedRoles = Optional.of((Set)allowedRoles.orElseThrow().stream().map(role -> this.roleMaps.get(this.resourceInfo.getResourceClass()).getOrDefault(role, (String)role)).collect(ImmutableSet.toImmutableSet()));
        }
        if (!(result = this.authorizer.authorize(principal, allowedRoles.orElseThrow(), request.getUriInfo().getRequestUri().toString())).isAllowed()) {
            request.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)String.format("Principal %s is not allowed to access the resource. Reason: %s", principal.getName(), result.getReason())).build());
        }
    }

    private Optional<Set<String>> getAllowedRoles() {
        if (this.resourceInfo.getResourceMethod().isAnnotationPresent(RolesAllowed.class)) {
            return Optional.of(ImmutableSet.copyOf((Object[])this.resourceInfo.getResourceMethod().getAnnotation(RolesAllowed.class).value()));
        }
        if (this.resourceInfo.getResourceClass().isAnnotationPresent(RolesAllowed.class)) {
            return Optional.of(ImmutableSet.copyOf((Object[])this.resourceInfo.getResourceClass().getAnnotation(RolesAllowed.class).value()));
        }
        return Optional.empty();
    }
}

