/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jaxrs;

import com.google.common.collect.ImmutableSet;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;

public abstract class BaseMapper
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Set<Class<?>> IO_CLASSES = ImmutableSet.builder().add(InputStream.class).add(Reader.class).add(OutputStream.class).add(Writer.class).add(byte[].class).add(char[].class).add(StreamingOutput.class).add(Response.class).build();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return BaseMapper.canReadOrWrite(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return BaseMapper.canReadOrWrite(type);
    }

    private static boolean canReadOrWrite(Class<?> type) {
        if (IO_CLASSES.contains(type)) {
            return false;
        }
        for (Class<?> ioClass : IO_CLASSES) {
            if (!ioClass.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    public long getSize(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }
}

