/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jaxrs;

import com.google.common.base.Strings;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;

@Provider
@PreMatching
public class OverrideMethodFilter
implements ContainerRequestFilter {
    public static final String HEADER = "X-HTTP-Method-Override";
    public static final String METHOD_PARAM = "_method";

    public void filter(ContainerRequestContext request) {
        String method = (String)request.getHeaders().getFirst((Object)HEADER);
        if (Strings.isNullOrEmpty((String)method)) {
            method = (String)request.getUriInfo().getQueryParameters().getFirst((Object)METHOD_PARAM);
        }
        if (!Strings.isNullOrEmpty((String)method)) {
            if (request.getMethod().equalsIgnoreCase("POST")) {
                request.setMethod(method);
            } else {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
    }
}

