/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jaxrs.testing;

import com.facebook.airlift.jaxrs.testing.GuavaMultivaluedMap;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class MockUriInfo
implements UriInfo {
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/');
    private static final Splitter QUERY_STRING_SPLITTER = Splitter.on((char)'&').trimResults().omitEmptyStrings();
    private static final Splitter QUERY_PARAM_SPLITTER = Splitter.on((char)'=');
    private static final Joiner QUERY_PARAM_VALUE_JOINER = Joiner.on((String)"");
    private final URI requestUri;
    private final URI baseUri;

    public static UriInfo from(String requestUri) {
        return new MockUriInfo(URI.create(requestUri));
    }

    public static UriInfo from(URI requestUri) {
        return new MockUriInfo(requestUri);
    }

    public MockUriInfo(URI requestUri) {
        this(requestUri, requestUri.resolve("/"));
    }

    public MockUriInfo(URI requestUri, URI baseUri) {
        this.requestUri = requestUri;
        this.baseUri = baseUri;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.getBaseUri());
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.getRequestUri());
    }

    public URI getAbsolutePath() {
        return UriBuilder.fromUri((URI)this.requestUri).replaceQuery("").fragment("").build(new Object[0]);
    }

    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri((URI)this.getAbsolutePath());
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        return this.getRequestUri().getRawPath().substring(this.getBaseUri().getRawPath().length());
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String path : PATH_SPLITTER.split((CharSequence)this.getPath(decode))) {
            builder.add((Object)new ImmutablePathSegment(path));
        }
        return builder.build();
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        return MockUriInfo.decodeQuery(this.getRequestUri().getRawQuery(), decode);
    }

    public URI resolve(URI uri) {
        return this.baseUri.resolve(uri);
    }

    public URI relativize(URI uri) {
        if (!uri.isAbsolute()) {
            uri = this.resolve(uri);
        }
        return this.baseUri.resolve(uri);
    }

    public static MultivaluedMap<String, String> decodeQuery(String query, boolean decode) {
        if (query == null) {
            return new GuavaMultivaluedMap<String, String>();
        }
        ArrayListMultimap map = ArrayListMultimap.create();
        for (String param : QUERY_STRING_SPLITTER.split((CharSequence)query)) {
            ImmutableList pair = ImmutableList.copyOf((Iterable)QUERY_PARAM_SPLITTER.split((CharSequence)param));
            if (pair.isEmpty()) continue;
            String key = MockUriInfo.urlDecode((String)pair.get(0));
            String value = null;
            if (pair.size() != 1) {
                value = QUERY_PARAM_VALUE_JOINER.join(pair.subList(1, pair.size()));
                if (decode) {
                    value = MockUriInfo.urlDecode(value);
                }
            }
            map.put((Object)key, value);
        }
        return new GuavaMultivaluedMap<String, String>((Multimap<String, String>)map);
    }

    private static String urlDecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        throw new UnsupportedOperationException();
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public String getMatchedResourceTemplate() {
        return "";
    }

    public List<String> getMatchedURIs(boolean decode) {
        throw new UnsupportedOperationException();
    }

    public List<Object> getMatchedResources() {
        throw new UnsupportedOperationException();
    }

    private static class ImmutablePathSegment
    implements PathSegment {
        private final String path;

        public ImmutablePathSegment(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public MultivaluedMap<String, String> getMatrixParameters() {
            return new GuavaMultivaluedMap<String, String>();
        }
    }
}

