/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jaxrs;

import com.facebook.airlift.jaxrs.BaseMapper;
import com.facebook.airlift.jaxrs.JsonMapperParsingException;
import com.facebook.airlift.log.Logger;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.dataformat.smile.SmileParser;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Provider
@Consumes(value={"application/x-jackson-smile"})
@Produces(value={"application/x-jackson-smile; qs=0.1"})
public class SmileMapper
extends BaseMapper {
    public static final Logger log = Logger.get(SmileMapper.class);
    private final ObjectMapper objectMapper;

    @Inject
    public SmileMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException {
        Object object;
        try {
            SmileParser jsonParser = new SmileFactory().createParser(inputStream);
            jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            object = this.objectMapper.readValue((JsonParser)jsonParser, this.objectMapper.getTypeFactory().constructType(genericType));
        }
        catch (Exception e) {
            if (e instanceof IOException && !(e instanceof JsonProcessingException) && !(e instanceof EOFException)) {
                throw (IOException)e;
            }
            log.debug((Throwable)e, "Invalid json for Java type %s", new Object[]{type});
            throw new JsonMapperParsingException(type, (Throwable)e);
        }
        return object;
    }

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        SmileGenerator jsonGenerator = new SmileFactory().createGenerator(outputStream);
        jsonGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        JavaType rootType = null;
        if (genericType != null && value != null && genericType.getClass() != Class.class && (rootType = this.objectMapper.getTypeFactory().constructType(genericType)).getRawClass() == Object.class) {
            rootType = null;
        }
        if (rootType != null) {
            this.objectMapper.writerFor(rootType).writeValue((JsonGenerator)jsonGenerator, value);
        } else {
            this.objectMapper.writeValue((JsonGenerator)jsonGenerator, value);
        }
    }
}

