/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jaxrs;

import com.facebook.airlift.jaxrs.JaxrsResource;
import com.facebook.airlift.jaxrs.RoleMapping;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.util.Map;
import java.util.Objects;

public class JaxrsBinder {
    private final Multibinder<Object> resourceBinder;
    private final Binder binder;
    private final MapBinder<Class<?>, Map<String, String>> resourceRolesMappingBinder;

    private JaxrsBinder(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass()});
        this.resourceBinder = Multibinder.newSetBinder((Binder)binder, Object.class, JaxrsResource.class).permitDuplicates();
        this.resourceRolesMappingBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<Map<String, String>>(){}, RoleMapping.class);
    }

    public static JaxrsBinder jaxrsBinder(Binder binder) {
        return new JaxrsBinder(binder);
    }

    public ResourceBinding bind(Class<?> implementation) {
        this.binder.bind(implementation).in(Scopes.SINGLETON);
        this.resourceBinder.addBinding().to(implementation).in(Scopes.SINGLETON);
        return new ResourceBinding(implementation, this.resourceRolesMappingBinder);
    }

    public void bind(TypeLiteral<?> implementation) {
        this.binder.bind(implementation).in(Scopes.SINGLETON);
        this.resourceBinder.addBinding().to(implementation).in(Scopes.SINGLETON);
    }

    public void bind(Key<?> targetKey) {
        this.binder.bind(targetKey).in(Scopes.SINGLETON);
        this.resourceBinder.addBinding().to(targetKey).in(Scopes.SINGLETON);
    }

    public ResourceBinding bindInstance(Object instance) {
        this.resourceBinder.addBinding().toInstance(instance);
        return new ResourceBinding(instance.getClass(), this.resourceRolesMappingBinder);
    }

    public static class ResourceBinding {
        private final Class<?> implementation;
        private final MapBinder<Class<?>, Map<String, String>> resourceRolesMappingBinder;

        public ResourceBinding(Class<?> implementation, MapBinder<Class<?>, Map<String, String>> resourceRolesMappingBinder) {
            this.implementation = implementation;
            this.resourceRolesMappingBinder = resourceRolesMappingBinder;
        }

        public ResourceBinding withRolesMapping(Map<String, String> rolesMapping) {
            this.resourceRolesMappingBinder.addBinding(this.implementation).toInstance((Object)ImmutableMap.copyOf(rolesMapping));
            return this;
        }
    }
}

